/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.neoforge.inventory.energy;

import net.creeperhost.polylib.inventory.energy.PlatformItemEnergyManager;
import net.creeperhost.polylib.inventory.item.ItemStackHolder;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public record NeoForgeItemEnergyManager(IEnergyStorage energy) implements PlatformItemEnergyManager
{
    public NeoForgeItemEnergyManager(ItemStack energyItem) {
        this((IEnergyStorage)energyItem.getCapability(Capabilities.EnergyStorage.ITEM));
    }

    @Override
    public long getStoredEnergy() {
        return this.energy.getEnergyStored();
    }

    @Override
    public long getCapacity() {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public long extract(ItemStackHolder holder, long amount, boolean simulate) {
        return this.energy.extractEnergy((int)amount, simulate);
    }

    @Override
    public long insert(ItemStackHolder holder, long amount, boolean simulate) {
        return this.energy.receiveEnergy((int)amount, simulate);
    }

    @Override
    public boolean supportsInsertion() {
        return this.energy.canReceive();
    }

    @Override
    public boolean supportsExtraction() {
        return this.energy.canExtract();
    }
}

