/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BaseBlockEntity
extends BlockEntity {
    private boolean dataChanged = true;

    public BaseBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void dataChanged() {
        this.dataChanged = true;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 6);
    }

    protected abstract CompoundTag writeData();

    protected CompoundTag writeClientData() {
        return this.writeData();
    }

    protected CompoundTag writeItemStackData() {
        return this.writeData();
    }

    protected abstract void readData(CompoundTag var1);

    protected void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        CompoundTag data = this.writeData();
        if (data != null && !data.isEmpty()) {
            compound.put("data", (Tag)data);
        }
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.readData(nbt.getCompound("data"));
    }

    public CompoundTag getUpdateTag() {
        CompoundTag tag = new CompoundTag();
        super.saveAdditional(tag);
        CompoundTag data = this.writeClientData();
        if (data != null && !data.isEmpty()) {
            tag.put("data", (Tag)data);
        }
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.load(tag);
        this.readData(tag.getCompound("data"));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.dataChanged) {
            this.dataChanged = false;
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this, entity -> {
                CompoundTag data = ((BaseBlockEntity)((Object)entity)).writeClientData();
                return data != null ? data : new CompoundTag();
            });
        }
        return null;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readData(pkt.getTag() == null ? new CompoundTag() : pkt.getTag());
    }
}

