/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.mixin.BlockPropertiesAccessor;
import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.util.TriPredicate;

public class BlockProperties {
    private static final Function<BlockBehaviour.Properties, BlockBehaviour.StatePredicate> isRedstoneConductorField;
    private Function<BlockState, MapColor> mapColor;
    private boolean hasCollision = true;
    private boolean canOcclude = true;
    private SoundType soundType = SoundType.STONE;
    private ToIntFunction<BlockState> lightLevel = state -> 0;
    private float explosionResistance;
    private float destroyTime;
    private boolean requiresCorrectTool = false;
    private boolean ticksRandomly = false;
    private float friction = 0.6f;
    private float speedFactor = 1.0f;
    private float jumpFactor = 1.0f;
    private boolean isAir = false;
    private TriPredicate<BlockState, BlockGetter, BlockPos> isRedstoneConductor = BlockBehaviour.BlockStateBase::isCollisionShapeFullBlock;
    private TriPredicate<BlockState, BlockGetter, BlockPos> isSuffocating = (state, level, pos) -> state.blocksMotion() && state.isCollisionShapeFullBlock(level, pos);
    private boolean hasDynamicShape = false;
    private boolean noLootTable = false;
    private Supplier<ResourceLocation> lootTableSupplier;

    public static BlockProperties create() {
        return new BlockProperties();
    }

    public static BlockProperties copy(Block block) {
        BlockBehaviour.Properties sourceProperties = block.properties;
        BlockProperties properties = BlockProperties.create();
        properties.mapColor = sourceProperties.mapColor;
        properties.hasCollision = sourceProperties.hasCollision;
        properties.canOcclude = block.defaultBlockState().canOcclude();
        properties.soundType = block.getSoundType(block.defaultBlockState());
        properties.lightLevel = sourceProperties.lightEmission;
        properties.explosionResistance = block.getExplosionResistance();
        properties.destroyTime = block.defaultDestroyTime();
        properties.requiresCorrectTool = block.defaultBlockState().requiresCorrectToolForDrops();
        properties.ticksRandomly = block.isRandomlyTicking(block.defaultBlockState());
        properties.friction = block.getFriction();
        properties.speedFactor = block.getSpeedFactor();
        properties.jumpFactor = block.getJumpFactor();
        properties.isAir = block.defaultBlockState().isAir();
        properties.isRedstoneConductor = (arg_0, arg_1, arg_2) -> ((BlockBehaviour.StatePredicate)isRedstoneConductorField.apply(sourceProperties)).test(arg_0, arg_1, arg_2);
        properties.isSuffocating = (arg_0, arg_1, arg_2) -> ((BlockBehaviour.StatePredicate)sourceProperties.isSuffocating).test(arg_0, arg_1, arg_2);
        properties.hasDynamicShape = block.hasDynamicShape();
        properties.lootTableSupplier = sourceProperties.drops != null ? () -> sourceProperties.drops : ((BlockPropertiesAccessor)sourceProperties).getLootTableSupplier();
        return properties;
    }

    public BlockProperties mapColor(Function<BlockState, MapColor> colorFunction) {
        this.mapColor = colorFunction;
        return this;
    }

    public BlockProperties mapColor(MapColor color) {
        return this.mapColor((BlockState state) -> color);
    }

    public BlockProperties noCollision() {
        this.hasCollision = false;
        this.canOcclude = false;
        return this;
    }

    public BlockProperties noOcclusion() {
        this.canOcclude = false;
        return this;
    }

    public BlockProperties sound(SoundType soundTypeIn) {
        this.soundType = soundTypeIn;
        return this;
    }

    public BlockProperties lightLevel(ToIntFunction<BlockState> stateLightFunction) {
        this.lightLevel = stateLightFunction;
        return this;
    }

    public BlockProperties lightLevel(int light) {
        this.lightLevel = state -> light;
        return this;
    }

    public BlockProperties explosionResistance(float resistance) {
        this.explosionResistance = Math.max(0.0f, resistance);
        return this;
    }

    public BlockProperties destroyTime(float destroyTime) {
        this.destroyTime = destroyTime;
        return this;
    }

    public BlockProperties requiresCorrectTool() {
        this.requiresCorrectTool = true;
        return this;
    }

    public BlockProperties randomTicks() {
        this.ticksRandomly = true;
        return this;
    }

    public BlockProperties friction(float friction) {
        this.friction = friction;
        return this;
    }

    public BlockProperties speedFactor(float factor) {
        this.speedFactor = factor;
        return this;
    }

    public BlockProperties jumpFactor(float factor) {
        this.jumpFactor = factor;
        return this;
    }

    public BlockProperties air() {
        this.isAir = true;
        return this;
    }

    public BlockProperties isRedstoneConductor(TriPredicate<BlockState, BlockGetter, BlockPos> isRedstoneConductor) {
        this.isRedstoneConductor = isRedstoneConductor;
        return this;
    }

    public BlockProperties isRedstoneConductor(boolean isRedstoneConductor) {
        this.isRedstoneConductor = (state, blockGetter, pos) -> isRedstoneConductor;
        return this;
    }

    public BlockProperties isSuffocating(TriPredicate<BlockState, BlockGetter, BlockPos> isSuffocating) {
        this.isSuffocating = isSuffocating;
        return this;
    }

    public BlockProperties isSuffocating(boolean isSuffocating) {
        this.isSuffocating = (state, blockGetter, pos) -> isSuffocating;
        return this;
    }

    public BlockProperties dynamicShape() {
        this.hasDynamicShape = true;
        return this;
    }

    public BlockProperties noLootTable() {
        this.noLootTable = true;
        this.lootTableSupplier = null;
        return this;
    }

    public BlockProperties lootTable(ResourceLocation lootTable) {
        this.noLootTable = false;
        this.lootTableSupplier = () -> lootTable;
        return this;
    }

    public BlockProperties lootTableFrom(Supplier<Block> block) {
        this.noLootTable = false;
        this.lootTableSupplier = block == null ? null : () -> ((Block)block.get()).getLootTable();
        return this;
    }

    @Deprecated
    public BlockBehaviour.Properties toUnderlying() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of();
        if (this.mapColor != null) {
            properties.mapColor(this.mapColor);
        }
        if (!this.hasCollision) {
            properties.noCollission();
        }
        properties.sound(this.soundType);
        properties.lightLevel(this.lightLevel);
        properties.strength(this.explosionResistance);
        properties.destroyTime(this.destroyTime);
        if (this.requiresCorrectTool) {
            properties.requiresCorrectToolForDrops();
        }
        if (this.ticksRandomly) {
            properties.randomTicks();
        }
        properties.friction(this.friction);
        properties.speedFactor(this.speedFactor);
        properties.jumpFactor(this.jumpFactor);
        if (this.noLootTable) {
            properties.noLootTable();
        }
        ((BlockPropertiesAccessor)properties).setLootTableSupplier(this.lootTableSupplier);
        if (!this.canOcclude) {
            properties.noOcclusion();
        }
        if (this.isAir) {
            properties.air();
        }
        properties.isRedstoneConductor((arg_0, arg_1, arg_2) -> this.isRedstoneConductor.test(arg_0, arg_1, arg_2));
        properties.isSuffocating((arg_0, arg_1, arg_2) -> this.isSuffocating.test(arg_0, arg_1, arg_2));
        properties.isViewBlocking((arg_0, arg_1, arg_2) -> this.isSuffocating.test(arg_0, arg_1, arg_2));
        if (this.hasDynamicShape) {
            properties.dynamicShape();
        }
        return properties;
    }

    static {
        try {
            Field field = BlockBehaviour.Properties.class.getDeclaredField("isRedstoneConductor");
            field.setAccessible(true);
            isRedstoneConductorField = properties -> {
                try {
                    return (BlockBehaviour.StatePredicate)field.get(properties);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

