/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockShape {
    private final VoxelShape shape;

    public static BlockShape create(AABB box) {
        return new BlockShape(box);
    }

    public static BlockShape create(VoxelShape box) {
        return new BlockShape(box);
    }

    public static BlockShape create(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BlockShape.create(Shapes.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
    }

    public static BlockShape createBlockShape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BlockShape.create(Shapes.box((double)(x1 / 16.0), (double)(y1 / 16.0), (double)(z1 / 16.0), (double)(x2 / 16.0), (double)(y2 / 16.0), (double)(z2 / 16.0)));
    }

    public static BlockShape or(BlockShape shape, BlockShape ... shapes) {
        return new BlockShape(Shapes.or((VoxelShape)shape.shape, (VoxelShape[])((VoxelShape[])Arrays.stream(shapes).map(s -> s.shape).toArray(VoxelShape[]::new))));
    }

    public static BlockShape fullCube() {
        return new BlockShape(Shapes.block());
    }

    public static BlockShape empty() {
        return new BlockShape(Shapes.empty());
    }

    public static boolean intersects(BlockShape shape1, BlockShape shape2) {
        return shape1.intersects(shape2);
    }

    public BlockShape(VoxelShape shape) {
        this.shape = shape;
    }

    public BlockShape(AABB shape) {
        this(Shapes.create((AABB)shape));
    }

    public BlockShape(List<AABB> shapes) {
        this(Shapes.or((VoxelShape)Shapes.empty(), (VoxelShape[])((VoxelShape[])shapes.stream().map(Shapes::create).toArray(VoxelShape[]::new))));
    }

    public List<AABB> toBoxes() {
        return this.shape.toAabbs();
    }

    public void forEachBox(Consumer<AABB> action) {
        this.toBoxes().forEach(action);
    }

    public void forEachEdge(LineConsumer action) {
        this.shape.forAllEdges(action::apply);
    }

    public void forEachCorner(PointConsumer action) {
        this.shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
            action.apply(x1, y1, z1);
            action.apply(x2, y1, z1);
            action.apply(x1, y1, z2);
            action.apply(x2, y1, z2);
            action.apply(x1, y2, z1);
            action.apply(x2, y2, z1);
            action.apply(x1, y2, z2);
            action.apply(x2, y2, z2);
        });
    }

    public AABB simplify() {
        return this.shape.bounds();
    }

    public double getStart(Direction.Axis axis) {
        return this.shape.min(axis);
    }

    public double getEnd(Direction.Axis axis) {
        return this.shape.max(axis);
    }

    public double minX() {
        return this.getStart(Direction.Axis.X);
    }

    public double minY() {
        return this.getStart(Direction.Axis.Y);
    }

    public double minZ() {
        return this.getStart(Direction.Axis.Z);
    }

    public double maxX() {
        return this.getEnd(Direction.Axis.X);
    }

    public double maxY() {
        return this.getEnd(Direction.Axis.Y);
    }

    public double maxZ() {
        return this.getEnd(Direction.Axis.Z);
    }

    public boolean isEmpty() {
        return this.shape.isEmpty();
    }

    public BlockShape offset(double x, double y, double z) {
        return new BlockShape(this.shape.move(x, y, z));
    }

    public BlockShape offset(BlockPos pos) {
        return new BlockShape(this.shape.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
    }

    public BlockShape offset(Direction direction) {
        return this.offset(direction.getStepX(), direction.getStepY(), direction.getStepZ());
    }

    public boolean intersects(BlockShape shape) {
        if (this.isEmpty() || shape.isEmpty()) {
            return false;
        }
        return this.maxX() > shape.minX() && this.minX() < shape.maxX() && this.maxY() > shape.minY() && this.minY() < shape.maxY() && this.maxZ() > shape.minZ() && this.minZ() < shape.maxZ();
    }

    public BlockShape grow(double amount) {
        return this.transformBoxes(box -> box.inflate(amount));
    }

    public BlockShape shrink(double amount) {
        return this.transformBoxes(box -> box.deflate(amount));
    }

    public BlockShape flip(Direction.Axis axis) {
        return this.transformBoxes(box -> new AABB(axis == Direction.Axis.X ? 1.0 - box.minX : box.minX, axis == Direction.Axis.Y ? 1.0 - box.minY : box.minY, axis == Direction.Axis.Z ? 1.0 - box.minZ : box.minZ, axis == Direction.Axis.X ? 1.0 - box.maxX : box.maxX, axis == Direction.Axis.Y ? 1.0 - box.maxY : box.maxY, axis == Direction.Axis.Z ? 1.0 - box.maxZ : box.maxZ));
    }

    public BlockShape rotate(Direction.Axis axis) {
        if (axis == null) {
            throw new IllegalArgumentException("axis must not be null!");
        }
        if (axis == Direction.Axis.X) {
            return this.transformBoxes(box -> new AABB(box.minX, box.minZ, -box.minY + 1.0, box.maxX, box.maxZ, -box.maxY + 1.0));
        }
        if (axis == Direction.Axis.Y) {
            return this.transformBoxes(box -> new AABB(-box.minZ + 1.0, box.minY, box.minX, -box.maxZ + 1.0, box.maxY, box.maxX));
        }
        if (axis == Direction.Axis.Z) {
            return this.transformBoxes(box -> new AABB(box.minY, -box.minX + 1.0, box.minZ, box.maxY, -box.maxX + 1.0, box.maxZ));
        }
        return null;
    }

    private BlockShape transformBoxes(Function<AABB, AABB> transformer) {
        return new BlockShape(this.toBoxes().stream().map(transformer::apply).collect(Collectors.toList()));
    }

    @Deprecated
    public VoxelShape getUnderlying() {
        return this.shape;
    }

    public static interface LineConsumer {
        public void apply(double var1, double var3, double var5, double var7, double var9, double var11);
    }

    public static interface PointConsumer {
        public void apply(double var1, double var3, double var5);
    }
}

