/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.neoforged.neoforge.common.conditions.ICondition;

public class AndResourceCondition
implements ResourceCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final List<ICondition> conditions;

    public AndResourceCondition(ICondition ... conditions) {
        this.conditions = new ArrayList<ICondition>(Arrays.asList(conditions));
    }

    public AndResourceCondition(ResourceCondition ... conditions) {
        this((ICondition[])Arrays.stream(conditions).map(ResourceCondition::createForgeCondition).toArray(ICondition[]::new));
    }

    @Override
    public boolean test(ResourceConditionContext context) {
        for (ICondition condition : this.conditions) {
            if (condition.test(context.getUnderlying())) continue;
            return false;
        }
        return true;
    }

    @Override
    public ResourceConditionSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public ResourceCondition and(ResourceCondition condition) {
        this.conditions.add(ResourceCondition.createForgeCondition(condition));
        return this;
    }

    private static class Serializer
    implements ResourceConditionSerializer<AndResourceCondition> {
        private Serializer() {
        }

        @Override
        public void serialize(JsonObject json, AndResourceCondition condition) {
            JsonArray conditions = new JsonArray();
            for (ICondition alternative : condition.conditions) {
                conditions.add((JsonElement)ICondition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)alternative).getOrThrow(false, s -> {}));
            }
            json.add("conditions", (JsonElement)conditions);
        }

        @Override
        public AndResourceCondition deserialize(JsonObject json) {
            if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
                throw new RuntimeException("Condition must have key 'conditions' with a json array!");
            }
            JsonArray conditionsJson = json.getAsJsonArray("conditions");
            ICondition[] conditions = new ICondition[conditionsJson.size()];
            for (int i = 0; i < conditionsJson.size(); ++i) {
                conditions[i] = (ICondition)((Pair)ICondition.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)conditionsJson.get(i).getAsJsonObject()).getOrThrow(false, s -> {})).getFirst();
            }
            return new AndResourceCondition(conditions);
        }
    }
}

