/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.condition;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.supermartijn642.core.codec.CodecHelper;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.neoforge.common.conditions.ICondition;

class ResourceConditions {
    private static final Map<ResourceConditionSerializer<?>, Codec<? extends ICondition>> TO_UNDERLYING_MAP = new HashMap();

    ResourceConditions() {
    }

    static ConditionWrapper wrap(ResourceCondition condition) {
        return new ConditionWrapper(condition);
    }

    static Codec<? extends ICondition> serializerCodec(ResourceConditionSerializer<?> serializer) {
        return TO_UNDERLYING_MAP.computeIfAbsent(serializer, s -> CodecHelper.jsonSerializerToCodec(input -> {
            JsonObject json = new JsonObject();
            serializer.serialize(json, input.condition);
            return json;
        }, json -> new ConditionWrapper((ResourceCondition)serializer.deserialize(json.getAsJsonObject()))));
    }

    private static class ConditionWrapper
    implements ICondition {
        private final ResourceCondition condition;

        ConditionWrapper(ResourceCondition condition) {
            this.condition = condition;
        }

        public boolean test(ICondition.IContext context) {
            return this.condition.test(new ResourceConditionContext(context));
        }

        public Codec<? extends ICondition> codec() {
            return ResourceConditions.serializerCodec(this.condition.getSerializer());
        }
    }
}

