/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.ApiStatus;

public abstract class ResourceGenerator {
    protected final String modid;
    protected final String modName;
    protected final ResourceCache cache;

    public static DataProvider createDataProvider(ResourceGenerator generator) {
        return new DataProviderInstance(generator);
    }

    public ResourceGenerator(String modid, ResourceCache cache) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName() + "' is creating a resource generator with different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is creating a resource generator with modid '" + modid + "'!");
        }
        this.modid = modid;
        this.cache = cache;
        Optional modContainer = ModList.get().getModContainerById(modid);
        this.modName = modContainer.map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modid);
    }

    public abstract void generate();

    public abstract void save();

    public String getName() {
        return this.modName + " Resource Generator";
    }

    public final String getOwnerModid() {
        return this.modid;
    }

    @ApiStatus.Internal
    public static class DataProviderInstance
    implements DataProvider {
        private final ResourceGenerator generator;
        private boolean generated = false;

        public DataProviderInstance(ResourceGenerator generator) {
            this.generator = generator;
        }

        public void generate() {
            this.generated = true;
            this.generator.generate();
        }

        public CompletableFuture<?> run(CachedOutput output) {
            if (!this.generated) {
                this.generator.generate();
            }
            this.generator.save();
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }

        public String getName() {
            return this.generator.getName();
        }
    }
}

