/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.item.EditableClientItemExtensions;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.core.render.CustomItemRenderer;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.core.util.TriFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import org.jetbrains.annotations.ApiStatus;

public class ClientRegistrationHandler {
    private static final Map<String, ClientRegistrationHandler> REGISTRATION_HELPER_MAP = new HashMap<String, ClientRegistrationHandler>();
    private final String modid;
    private final Set<ResourceLocation> models = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, Supplier<BakedModel>> specialModels = new HashMap<ResourceLocation, Supplier<BakedModel>>();
    private final List<Pair<Supplier<Stream<ResourceLocation>>, Function<BakedModel, BakedModel>>> modelOverwrites = new ArrayList<Pair<Supplier<Stream<ResourceLocation>>, Function<BakedModel, BakedModel>>>();
    private final List<Pair<Supplier<EntityType<?>>, Function<EntityRendererProvider.Context, EntityRenderer<?>>>> entityRenderers = new ArrayList();
    private final List<Pair<Supplier<BlockEntityType<?>>, Function<BlockEntityRendererProvider.Context, BlockEntityRenderer<?>>>> blockEntityRenderers = new ArrayList();
    private final Map<ResourceLocation, Set<ResourceLocation>> textureAtlasSprites = new HashMap<ResourceLocation, Set<ResourceLocation>>();
    private final List<Pair<Supplier<Item>, Supplier<BlockEntityWithoutLevelRenderer>>> customItemRenderers = new ArrayList<Pair<Supplier<Item>, Supplier<BlockEntityWithoutLevelRenderer>>>();
    private final List<Pair<Supplier<MenuType<?>>, TriFunction<AbstractContainerMenu, Inventory, Component, Screen>>> containerScreens = new ArrayList();
    private final List<Pair<Supplier<Block>, Supplier<RenderType>>> blockRenderTypes = new ArrayList<Pair<Supplier<Block>, Supplier<RenderType>>>();
    private boolean passedModelRegistry;
    private boolean passedModelBake;
    private boolean passedRegisterRenderers;
    private boolean passedTextureStitch;

    public static synchronized ClientRegistrationHandler get(String modid) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName() + "' is requesting registration helper for different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, ClientRegistrationHandler::new);
    }

    @ApiStatus.Internal
    public static void collectSprites(ResourceLocation atlas, Consumer<ResourceLocation> spriteConsumer) {
        for (ClientRegistrationHandler value : REGISTRATION_HELPER_MAP.values()) {
            value.addSprites(atlas, spriteConsumer);
        }
    }

    private ClientRegistrationHandler(String modid) {
        this.modid = modid;
        IEventBus eventBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        eventBus.addListener(this::handleModelRegistryEvent);
        eventBus.addListener(this::handleModelBakeEvent);
        eventBus.addListener(this::handleRegisterRenderersEvent);
        eventBus.addListener(this::handleRegisterMenuScreensEvent);
    }

    public void registerModel(ResourceLocation identifier) {
        if (this.passedModelRegistry) {
            throw new IllegalStateException("Cannot register new models after ModelRegistryEvent has been fired!");
        }
        if (this.models.contains(identifier)) {
            throw new RuntimeException("Duplicate model location '" + identifier + "'!");
        }
        if (this.specialModels.containsKey(identifier)) {
            throw new RuntimeException("Overlapping special model and model location '" + identifier + "'!");
        }
        this.models.add(identifier);
    }

    public void registerModel(String namespace, String identifier) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerModel(new ResourceLocation(namespace, identifier));
    }

    public void registerModel(String identifier) {
        this.registerModel(this.modid, identifier);
    }

    public void registerSpecialModel(String identifier, Supplier<BakedModel> model) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new special models after ModelBakeEvent has been fired!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        ResourceLocation fullIdentifier = new ResourceLocation(this.modid, identifier);
        if (this.specialModels.containsKey(fullIdentifier)) {
            throw new RuntimeException("Duplicate special model entry '" + fullIdentifier + "'!");
        }
        this.specialModels.put(fullIdentifier, model);
    }

    public void registerSpecialModel(String identifier, BakedModel model) {
        this.registerSpecialModel(identifier, () -> model);
    }

    public void registerModelOverwrite(ResourceLocation identifier, Function<BakedModel, BakedModel> modelOverwrite) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        if (this.specialModels.containsKey(identifier)) {
            throw new RuntimeException("Overlapping special model and model overwrite '" + identifier + "'!");
        }
        this.modelOverwrites.add(Pair.of(() -> Stream.of(identifier), modelOverwrite));
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, Function<BakedModel, BakedModel> modelOverwrite) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        if (!RegistryUtil.isValidPath(variant)) {
            throw new IllegalArgumentException("Variant '" + variant + "' must only contain characters [a-z0-9_./-]!");
        }
        ModelResourceLocation fullIdentifier = new ModelResourceLocation(namespace, identifier, variant);
        this.registerModelOverwrite((ResourceLocation)fullIdentifier, modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, Function<BakedModel, BakedModel> modelOverwrite) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        ResourceLocation fullIdentifier = new ResourceLocation(namespace, identifier);
        this.registerModelOverwrite(fullIdentifier, modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, Supplier<BakedModel> modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, variant, (BakedModel model) -> (BakedModel)modelOverwrite.get());
    }

    public void registerModelOverwrite(String namespace, String identifier, Supplier<BakedModel> modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, (BakedModel model) -> (BakedModel)modelOverwrite.get());
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, BakedModel modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, variant, (BakedModel model) -> modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, BakedModel modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, (BakedModel model) -> modelOverwrite);
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, Function<BakedModel, BakedModel> modelOverwrite) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.modelOverwrites.add(Pair.of(() -> ((Block)block.get()).getStateDefinition().getPossibleStates().stream().map(BlockModelShaper::stateToModelLocation).map(ResourceLocation.class::cast), modelOverwrite));
        this.registerItemModelOverwrite(() -> ((Block)block.get()).asItem(), modelOverwrite);
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, Supplier<BakedModel> modelOverwrite) {
        this.registerBlockModelOverwrite(block, (BakedModel model) -> (BakedModel)modelOverwrite.get());
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, BakedModel modelOverwrite) {
        this.registerBlockModelOverwrite(block, (BakedModel model) -> modelOverwrite);
    }

    public void registerItemModelOverwrite(Supplier<Item> item, Function<BakedModel, BakedModel> modelOverwrite) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.modelOverwrites.add(Pair.of(() -> Stream.of(new ModelResourceLocation(Registries.ITEMS.getIdentifier((Item)item.get()), "inventory")), modelOverwrite));
    }

    public void registerItemModelOverwrite(Supplier<Item> item, Supplier<BakedModel> modelOverwrite) {
        this.registerItemModelOverwrite(item, (BakedModel model) -> (BakedModel)modelOverwrite.get());
    }

    public void registerItemModelOverwrite(Supplier<Item> item, BakedModel modelOverwrite) {
        this.registerItemModelOverwrite(item, (BakedModel model) -> modelOverwrite);
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, Function<EntityRendererProvider.Context, EntityRenderer<? super T>> entityRenderer) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new renderers after RegisterRenderers has been fired!");
        }
        this.entityRenderers.add(Pair.of(entityType, entityRenderer));
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, Supplier<EntityRenderer<? super T>> entityRenderer) {
        this.registerEntityRenderer(entityType, (EntityRendererProvider.Context context) -> (EntityRenderer)entityRenderer.get());
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, EntityRenderer<? super T> entityRenderer) {
        this.registerEntityRenderer(entityType, (EntityRendererProvider.Context context) -> entityRenderer);
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, Function<BlockEntityRendererProvider.Context, BlockEntityRenderer<? super T>> blockEntityRenderer) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new renderers after RegisterRenderers has been fired!");
        }
        this.blockEntityRenderers.add(Pair.of(entityType, blockEntityRenderer));
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, Supplier<BlockEntityRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> (BlockEntityRenderer)blockEntityRenderer.get());
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, BlockEntityRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> blockEntityRenderer);
    }

    public <T extends BlockEntity> void registerCustomBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, Supplier<CustomBlockEntityRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> CustomBlockEntityRenderer.of((CustomBlockEntityRenderer)blockEntityRenderer.get()));
    }

    public <T extends BlockEntity> void registerCustomBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, CustomBlockEntityRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> CustomBlockEntityRenderer.of(blockEntityRenderer));
    }

    public void registerAtlasSprite(ResourceLocation textureAtlas, ResourceLocation spriteLocation) {
        if (this.passedTextureStitch) {
            throw new IllegalStateException("Cannot register new models after TextureStitchEvent has been fired!");
        }
        if (textureAtlas == null) {
            throw new IllegalArgumentException("Texture atlas must not be null!");
        }
        if (textureAtlas.getPath().startsWith("textures/atlas/") && textureAtlas.getPath().endsWith(".png")) {
            textureAtlas = new ResourceLocation(textureAtlas.getNamespace(), textureAtlas.getPath().substring("textures/atlas/".length(), textureAtlas.getPath().length() - ".png".length()));
        }
        this.textureAtlasSprites.putIfAbsent(textureAtlas, new HashSet());
        if (this.textureAtlasSprites.get(textureAtlas).contains(spriteLocation)) {
            throw new RuntimeException("Duplicate sprite registration '" + spriteLocation + "' for atlas '" + textureAtlas + "'!");
        }
        this.textureAtlasSprites.get(textureAtlas).add(spriteLocation);
    }

    public void registerAtlasSprite(ResourceLocation textureAtlas, String spriteLocation) {
        if (!RegistryUtil.isValidPath(spriteLocation)) {
            throw new IllegalArgumentException("Sprite location '" + spriteLocation + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerAtlasSprite(textureAtlas, new ResourceLocation(this.modid, spriteLocation));
    }

    public void registerItemRenderer(Supplier<Item> item, Supplier<BlockEntityWithoutLevelRenderer> itemRenderer) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new renderers after item RegistryEvent has been fired!");
        }
        this.customItemRenderers.add(Pair.of(item, itemRenderer));
    }

    public void registerItemRenderer(Supplier<Item> item, BlockEntityWithoutLevelRenderer itemRenderer) {
        this.registerItemRenderer(item, () -> itemRenderer);
    }

    public void registerItemRenderer(Item item, Supplier<BlockEntityWithoutLevelRenderer> itemRenderer) {
        this.registerItemRenderer(() -> item, itemRenderer);
    }

    public void registerItemRenderer(Item item, BlockEntityWithoutLevelRenderer itemRenderer) {
        this.registerItemRenderer(() -> item, () -> itemRenderer);
    }

    public void registerCustomItemRenderer(Supplier<Item> item, Supplier<CustomItemRenderer> itemRenderer) {
        this.registerItemRenderer(item, () -> CustomItemRenderer.of((CustomItemRenderer)itemRenderer.get()));
    }

    public void registerCustomItemRenderer(Supplier<Item> item, CustomItemRenderer itemRenderer) {
        this.registerItemRenderer(item, () -> CustomItemRenderer.of(itemRenderer));
    }

    public void registerCustomItemRenderer(Item item, Supplier<CustomItemRenderer> itemRenderer) {
        this.registerItemRenderer(() -> item, () -> CustomItemRenderer.of((CustomItemRenderer)itemRenderer.get()));
    }

    public void registerCustomItemRenderer(Item item, CustomItemRenderer itemRenderer) {
        this.registerItemRenderer(() -> item, () -> CustomItemRenderer.of(itemRenderer));
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(Supplier<MenuType<T>> menuType, TriFunction<T, Inventory, Component, U> screenSupplier) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.containerScreens.add(Pair.of(menuType, screenSupplier));
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(Supplier<MenuType<T>> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(menuType, (T container, Inventory inventory, Component title) -> (Screen)screenSupplier.apply(container));
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(MenuType<T> menuType, TriFunction<T, Inventory, Component, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, screenSupplier);
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(MenuType<T> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, (T container, Inventory inventory, Component title) -> (Screen)screenSupplier.apply(container));
    }

    @Deprecated
    public void registerBlockModelRenderType(Supplier<Block> block, Supplier<RenderType> renderTypeSupplier) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.blockRenderTypes.add(Pair.of(block, renderTypeSupplier));
    }

    @Deprecated
    public void registerBlockModelRenderType(Supplier<Block> block, RenderType renderType) {
        this.registerBlockModelRenderType(block, renderType);
    }

    @Deprecated
    public void registerBlockModelRenderType(Block block, Supplier<RenderType> renderTypeSupplier) {
        this.registerBlockModelRenderType(() -> block, renderTypeSupplier);
    }

    @Deprecated
    public void registerBlockModelSolidRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::solid);
    }

    @Deprecated
    public void registerBlockModelSolidRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::solid);
    }

    @Deprecated
    public void registerBlockModelCutoutMippedRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::cutoutMipped);
    }

    @Deprecated
    public void registerBlockModelCutoutMippedRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::cutoutMipped);
    }

    @Deprecated
    public void registerBlockModelCutoutRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::cutout);
    }

    @Deprecated
    public void registerBlockModelCutoutRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::cutout);
    }

    @Deprecated
    public void registerBlockModelTranslucentRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::translucent);
    }

    @Deprecated
    public void registerBlockModelTranslucentRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::translucent);
    }

    private void handleModelRegistryEvent(ModelEvent.RegisterAdditional e) {
        this.passedModelRegistry = true;
        for (ResourceLocation model : this.models) {
            e.register(model);
        }
    }

    private void handleModelBakeEvent(ModelEvent.ModifyBakingResult e) {
        this.passedModelBake = true;
        for (Map.Entry<ResourceLocation, Supplier<BakedModel>> entry : this.specialModels.entrySet()) {
            ResourceLocation identifier = entry.getKey();
            if (e.getModels().containsKey(identifier)) {
                throw new RuntimeException("Special model '" + identifier + "' is trying to overwrite another model!");
            }
            BakedModel model = entry.getValue().get();
            if (model == null) {
                throw new RuntimeException("Got null object for special model '" + entry.getKey() + "'!");
            }
            e.getModels().put(entry.getKey(), model);
        }
        for (Pair pair : this.modelOverwrites) {
            List modelIdentifiers;
            try (Stream stream = (Stream)((Supplier)pair.left()).get();){
                modelIdentifiers = stream.collect(Collectors.toList());
            }
            for (ResourceLocation identifier : modelIdentifiers) {
                if (!e.getModels().containsKey(identifier)) {
                    throw new RuntimeException("No model registered for model overwrite '" + identifier + "'!");
                }
                BakedModel model = (BakedModel)e.getModels().get(identifier);
                model = (BakedModel)((Function)pair.right()).apply(model);
                if (model == null) {
                    throw new RuntimeException("Model overwrite for '" + identifier + "' returned a null model!");
                }
                e.getModels().put(identifier, model);
            }
        }
    }

    private void handleRegisterRenderersEvent(EntityRenderersEvent.RegisterRenderers e) {
        this.passedRegisterRenderers = true;
        HashSet entityTypes = new HashSet();
        for (Pair<Supplier<EntityType<?>>, Function<EntityRendererProvider.Context, EntityRenderer<?>>> entry : this.entityRenderers) {
            EntityType<?> entityType = entry.left().get();
            if (entityType == null) {
                throw new RuntimeException("Entity renderer registered with null entity type!");
            }
            if (entityTypes.contains(entityType)) {
                throw new RuntimeException("Duplicate entity renderer for entity type '" + Registries.ENTITY_TYPES.getIdentifier(entityType) + "'!");
            }
            entityTypes.add(entityType);
            e.registerEntityRenderer(entityType, ((Function)entry.right())::apply);
        }
        HashSet<BlockEntityType> blockEntityTypes = new HashSet<BlockEntityType>();
        for (Pair pair : this.blockEntityRenderers) {
            BlockEntityType blockEntityType = (BlockEntityType)((Supplier)pair.left()).get();
            if (blockEntityType == null) {
                throw new RuntimeException("Block entity renderer registered with null block entity type!");
            }
            if (blockEntityTypes.contains(blockEntityType)) {
                throw new RuntimeException("Duplicate block entity renderer for block entity type '" + Registries.BLOCK_ENTITY_TYPES.getIdentifier(blockEntityType) + "'!");
            }
            blockEntityTypes.add(blockEntityType);
            e.registerBlockEntityRenderer(blockEntityType, ((Function)pair.right())::apply);
        }
        HashSet<Item> items = new HashSet<Item>();
        for (Pair<Supplier<Item>, Supplier<BlockEntityWithoutLevelRenderer>> pair : this.customItemRenderers) {
            Item item = pair.left().get();
            if (item == null) {
                throw new RuntimeException("Custom item renderer registered with null item!");
            }
            if (items.contains(item)) {
                throw new RuntimeException("Duplicate custom item renderer for item '" + Registries.ITEMS.getIdentifier(item) + "'!");
            }
            Object renderProperties = item.getRenderPropertiesInternal();
            if (!(renderProperties instanceof EditableClientItemExtensions)) {
                throw new RuntimeException("Cannot register custom item renderer for item '" + Registries.ITEMS.getIdentifier(item) + "' without EditableClientItemExtensions render properties!");
            }
            BlockEntityWithoutLevelRenderer customRenderer = pair.right().get();
            if (customRenderer == null) {
                throw new RuntimeException("Got null custom item renderer for item '" + Registries.ITEMS.getIdentifier(item) + "'!");
            }
            items.add(item);
            ((EditableClientItemExtensions)renderProperties).setCustomRenderer(customRenderer);
        }
        HashSet<Block> hashSet = new HashSet<Block>();
        for (Pair<Supplier<Block>, Supplier<RenderType>> entry : this.blockRenderTypes) {
            Block block = entry.left().get();
            if (block == null) {
                throw new RuntimeException("Block render type registered for null block!");
            }
            if (hashSet.contains(block)) {
                throw new RuntimeException("Duplicate render type for block '" + Registries.BLOCKS.getIdentifier(block) + "'!");
            }
            RenderType renderType = entry.right().get();
            if (renderType == null) {
                throw new RuntimeException("Got null render type for block '" + Registries.BLOCKS.getIdentifier(block) + "'!");
            }
            hashSet.add(block);
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
        }
    }

    private void handleRegisterMenuScreensEvent(RegisterMenuScreensEvent e) {
        HashSet menuTypes = new HashSet();
        for (Pair<Supplier<MenuType<?>>, TriFunction<AbstractContainerMenu, Inventory, Component, Screen>> entry : this.containerScreens) {
            MenuType<?> menuType = entry.left().get();
            if (menuType == null) {
                throw new RuntimeException("Container screen registered with null menu type!");
            }
            if (menuTypes.contains(menuType)) {
                throw new RuntimeException("Duplicate container screen for menu type '" + Registries.MENU_TYPES.getIdentifier(menuType) + "'!");
            }
            menuTypes.add(menuType);
            MenuScreens.register(menuType, entry.right()::apply);
        }
    }

    private void addSprites(ResourceLocation atlas, Consumer<ResourceLocation> spriteConsumer) {
        this.passedTextureStitch = true;
        Set<ResourceLocation> sprites = this.textureAtlasSprites.get(atlas);
        if (sprites == null) {
            return;
        }
        sprites.forEach(spriteConsumer);
    }
}

