/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.api;

import com.glodblock.github.extendedae.api.ICrystalFixer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CrystalFixer
implements ICrystalFixer {
    private final ArrayList<Block> crystalBlocks = new ArrayList();
    private Item fuel;

    public CrystalFixer(List<Block> crystalBlocks, Item fuel) {
        this.crystalBlocks.addAll(crystalBlocks);
        this.setFuelType(fuel);
    }

    @Override
    public void setFuelType(Item fuel) {
        this.fuel = fuel;
    }

    @Override
    public boolean canFix(BlockState crystal, ItemStack stack) {
        if (this.crystalBlocks.size() <= 1 || stack.getItem() != this.fuel) {
            return false;
        }
        for (int i = 0; i < this.crystalBlocks.size() - 1; ++i) {
            if (!crystal.is(this.crystalBlocks.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Block getNextCrystalBlock(BlockState crystalBlock) {
        Iterator<Block> iterator = this.crystalBlocks.iterator();
        while (iterator.hasNext()) {
            if (!crystalBlock.is(iterator.next()) || !iterator.hasNext()) continue;
            return iterator.next();
        }
        return null;
    }

    @Override
    public boolean isCrystal(Block block) {
        return this.crystalBlocks.contains(block);
    }

    @Override
    public Item getFuelType() {
        return this.fuel;
    }
}

