/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.Color;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.localization.GuiText;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.container.ContainerTagStorageBus;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.CEAEGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.glodium.network.packet.sync.Paras;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiTagStorageBus
extends UpgradeableScreen<ContainerTagStorageBus>
implements IActionHolder {
    private final Map<String, Consumer<Paras>> actions = this.createHolder();
    private final SettingToggleButton<AccessRestriction> rwMode;
    private final SettingToggleButton<StorageFilter> storageFilter;
    private final SettingToggleButton<YesNo> filterOnExtract;
    private final AETextField filterInputs;
    private final AETextField filterInputs2;
    private static final Pattern ORE_DICTIONARY_FILTER = Pattern.compile("[0-9a-zA-Z* &|^!():/_]*");

    public GuiTagStorageBus(ContainerTagStorageBus menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.widgets.addOpenPriorityButton();
        this.addToLeftToolbar((Button)new ActionButton(ActionItems.WRENCH, btn -> menu.partition()));
        this.rwMode = new ServerSettingToggleButton(Settings.ACCESS, (Enum)AccessRestriction.READ_WRITE);
        this.storageFilter = new ServerSettingToggleButton(Settings.STORAGE_FILTER, (Enum)StorageFilter.EXTRACTABLE_ONLY);
        this.filterOnExtract = new ServerSettingToggleButton(Settings.FILTER_ON_EXTRACT, (Enum)YesNo.YES);
        this.addToLeftToolbar((Button)this.storageFilter);
        this.addToLeftToolbar((Button)this.filterOnExtract);
        this.addToLeftToolbar((Button)this.rwMode);
        this.filterInputs = this.widgets.addTextField("filter_input");
        this.filterInputs.setFilter(str -> ORE_DICTIONARY_FILTER.matcher((CharSequence)str).matches());
        this.filterInputs.setMaxLength(512);
        this.filterInputs.setPlaceholder((Component)Component.translatable((String)"gui.extendedae.tag_storage_bus.tooltip"));
        this.filterInputs.setResponder(s -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("set", s, true)));
        this.filterInputs2 = this.widgets.addTextField("filter_input_2");
        this.filterInputs2.setFilter(str -> ORE_DICTIONARY_FILTER.matcher((CharSequence)str).matches());
        this.filterInputs2.setMaxLength(512);
        this.filterInputs2.setPlaceholder((Component)Component.translatable((String)"gui.extendedae.tag_storage_bus.tooltip"));
        this.filterInputs2.setResponder(s -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("set", s, false)));
        this.actions.put("init", o -> {
            this.filterInputs.setValue((String)o.get(0));
            this.filterInputs2.setValue((String)o.get(1));
        });
        EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("update"));
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.filterInputs.isMouseOver(xCoord, yCoord)) {
            this.filterInputs.setValue("");
        }
        if (btn == 1 && this.filterInputs2.isMouseOver(xCoord, yCoord)) {
            this.filterInputs2.setValue("");
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.storageFilter.set((Enum)((ContainerTagStorageBus)this.menu).getStorageFilter());
        this.rwMode.set((Enum)((ContainerTagStorageBus)this.menu).getReadWriteMode());
        this.filterOnExtract.set((Enum)((ContainerTagStorageBus)this.menu).getFilterOnExtract());
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawFG(guiGraphics, offsetX, offsetY, mouseX, mouseY);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(10.0f, 17.0f, 0.0f);
        poseStack.scale(0.6f, 0.6f, 1.0f);
        Color color = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR);
        if (((ContainerTagStorageBus)this.menu).getConnectedTo() != null) {
            guiGraphics.drawString(this.font, (Component)GuiText.AttachedTo.text(new Object[]{((ContainerTagStorageBus)this.menu).getConnectedTo()}), 0, 0, color.toARGB(), false);
        } else {
            guiGraphics.drawString(this.font, (Component)GuiText.Unattached.text(), 0, 0, color.toARGB(), false);
        }
        poseStack.popPose();
    }

    protected void init() {
        super.init();
        this.setInitialFocus((GuiEventListener)this.filterInputs);
    }

    @NotNull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.actions;
    }
}

