/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui.widget;

import appeng.client.gui.AEBaseScreen;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.scene.CameraSettings;
import appeng.client.guidebook.scene.GuidebookLevelRenderer;
import appeng.client.guidebook.scene.GuidebookScene;
import appeng.client.guidebook.scene.level.GuidebookLevel;
import com.glodblock.github.extendedae.util.Ae2ReflectClient;
import com.glodblock.github.glodium.util.GlodUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class WorldDisplay
extends AbstractWidget {
    private final AEBaseScreen<?> addedOn;
    private float zoom = 2.0f;
    private GuidebookScene scene;
    private boolean ready;
    private boolean hideNeighbor;
    @NotNull
    private static final Level clientWorld;
    private static final GuidebookLevelRenderer worldRender;
    private LytRect bounds;

    public WorldDisplay(AEBaseScreen<?> addedOn, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
        this.addedOn = addedOn;
        this.ready = false;
        this.hideNeighbor = false;
    }

    public void unload() {
        this.ready = false;
    }

    public void setHideNeighbor(boolean val) {
        this.hideNeighbor = val;
    }

    public void locate(BlockPos blockPos) {
        this.zoom = 2.0f;
        this.ready = false;
        BlockState block = clientWorld.getBlockState(blockPos);
        BlockEntity te = clientWorld.getBlockEntity(blockPos);
        if (block.isAir() || te == null) {
            return;
        }
        this.scene = new GuidebookScene(new GuidebookLevel(), new CameraSettings());
        ServerLevelAccessor wrap = Ae2ReflectClient.getFakeServerWorld((LevelAccessor)this.scene.getLevel());
        assert (wrap != null);
        Vec3i sizeX = new Vec3i(3, 1, 1);
        Vec3i sizeY = new Vec3i(1, 3, 1);
        Vec3i sizeZ = new Vec3i(1, 1, 3);
        BlockPos startX = BlockPos.ZERO.offset(0, 1, 1);
        BlockPos startY = BlockPos.ZERO.offset(1, 0, 1);
        BlockPos startZ = BlockPos.ZERO.offset(1, 1, 0);
        StructureTemplate tmp = new StructureTemplate();
        StructurePlaceSettings settings = new StructurePlaceSettings();
        SingleThreadedRandomSource random = new SingleThreadedRandomSource(0L);
        settings.setIgnoreEntities(true);
        if (this.hideNeighbor) {
            tmp.fillFromWorld(clientWorld, blockPos, new Vec3i(1, 1, 1), false, Blocks.AIR);
            tmp.placeInWorld(wrap, new BlockPos(1, 1, 1), BlockPos.ZERO, settings, (RandomSource)random, 0);
        } else {
            tmp.fillFromWorld(clientWorld, blockPos.offset(-1, 0, 0), sizeX, false, Blocks.AIR);
            tmp.placeInWorld(wrap, startX, BlockPos.ZERO, settings, (RandomSource)random, 0);
            tmp = new StructureTemplate();
            tmp.fillFromWorld(clientWorld, blockPos.offset(0, -1, 0), sizeY, false, Blocks.AIR);
            tmp.placeInWorld(wrap, startY, BlockPos.ZERO, settings, (RandomSource)random, 0);
            tmp = new StructureTemplate();
            tmp.fillFromWorld(clientWorld, blockPos.offset(0, 0, -1), sizeZ, false, Blocks.AIR);
            tmp.placeInWorld(wrap, startZ, BlockPos.ZERO, settings, (RandomSource)random, 0);
        }
        this.scene.getCameraSettings().setRotationCenter(this.scene.getWorldCenter());
        this.scene.getCameraSettings().setZoom(this.zoom);
        this.bounds = new LytRect(this.getX(), this.getY(), this.width, this.height);
        this.scene.getCameraSettings().setViewportSize(this.bounds.size());
        this.scene.centerScene();
        this.ready = true;
    }

    public void refreshBounds() {
        this.bounds = new LytRect(this.getX(), this.getY(), this.width, this.height);
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.ready) {
            if (this.isMouseOver(mouseX, mouseY)) {
                this.addedOn.setFocused((GuiEventListener)this);
            }
            Window window = Minecraft.getInstance().getWindow();
            LytRect viewport = this.bounds.transform(guiGraphics.pose().last().pose());
            RenderSystem.viewport((int)((int)((double)viewport.x() * window.getGuiScale())), (int)((int)((double)window.getHeight() - (double)viewport.bottom() * window.getGuiScale())), (int)((int)((double)viewport.width() * window.getGuiScale())), (int)((int)((double)viewport.height() * window.getGuiScale())));
            guiGraphics.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
            worldRender.render(this.scene.getLevel(), this.scene.getCameraSettings(), Collections.emptyList());
            guiGraphics.disableScissor();
            RenderSystem.viewport((int)0, (int)0, (int)window.getWidth(), (int)window.getHeight());
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.visible && this.ready && this.isMouseOver(pMouseX, pMouseY)) {
            float dx = (float)pDragX;
            float dy = (float)pDragY;
            CameraSettings camera = this.scene.getCameraSettings();
            if (pButton == 0) {
                camera.setRotationY(camera.getRotationY() + dx);
                camera.setRotationX(camera.getRotationX() + dy);
            } else if (pButton == 1) {
                camera.setOffsetX(camera.getOffsetX() + dx);
                camera.setOffsetY(camera.getOffsetY() - dy);
            }
        }
        return false;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.visible && this.ready && this.isMouseOver(pMouseX, pMouseY)) {
            this.zoom = (float)GlodUtil.clamp((double)((double)this.zoom + pScrollY / 5.0), (double)0.5, (double)10.0);
            this.scene.getCameraSettings().setZoom(this.zoom);
            return true;
        }
        return false;
    }

    static {
        worldRender = GuidebookLevelRenderer.getInstance();
        assert (Minecraft.getInstance().level != null);
        clientWorld = Minecraft.getInstance().level;
    }
}

