/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.blocks;

import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.api.orientation.RelativeSide;
import appeng.api.util.AEAxisAlignedBB;
import appeng.client.render.effects.LightningArcParticleData;
import appeng.core.AEConfig;
import appeng.core.AppEngClient;
import com.glodblock.github.extendedae.common.blocks.BlockBaseGui;
import com.glodblock.github.extendedae.common.tileentities.TileExCharger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BlockExCharger
extends BlockBaseGui<TileExCharger> {
    public BlockExCharger() {
        super(BlockExCharger.metalProps().noOcclusion());
    }

    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.full();
    }

    public int getLightBlock(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return 2;
    }

    @Override
    public void openGui(TileExCharger tile, Player p) {
        tile.activate(p);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        TileExCharger blockEntity = (TileExCharger)this.getBlockEntity((BlockGetter)level, pos);
        if (blockEntity != null && blockEntity.isWorking()) {
            if ((double)r.nextFloat() < 0.5) {
                return;
            }
            BlockOrientation rotation = BlockOrientation.get((BlockEntity)blockEntity);
            for (int bolts = 0; bolts < 3; ++bolts) {
                float xOff = Mth.randomBetween((RandomSource)r, (float)-0.15f, (float)0.15f);
                float zOff = Mth.randomBetween((RandomSource)r, (float)-0.15f, (float)0.15f);
                Vector3f center = new Vector3f((float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f);
                Vector3f origin = new Vector3f(xOff, -0.3f, zOff);
                origin.rotate((Quaternionfc)rotation.getQuaternion());
                origin.add((Vector3fc)center);
                Vector3f target = new Vector3f(xOff, 0.3f, zOff);
                target.rotate((Quaternionfc)rotation.getQuaternion());
                target.add((Vector3fc)center);
                if (r.nextBoolean()) {
                    Vector3f tmp = target;
                    target = origin;
                    origin = tmp;
                }
                if (!AppEngClient.instance().shouldAddParticles(r)) continue;
                Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)new LightningArcParticleData(new Vec3(target)), (double)origin.x(), (double)origin.y(), (double)origin.z(), 0.0, 0.0, 0.0);
            }
        }
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        BlockOrientation orientation = this.getOrientation(state);
        Direction forward = orientation.getSide(RelativeSide.FRONT);
        double twoPixels = 0.125;
        AEAxisAlignedBB bb = new AEAxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        switch (forward) {
            case UP: 
            case DOWN: {
                bb.maxY = 1.0 - twoPixels;
                bb.minY = 0.0 + twoPixels;
                break;
            }
            case SOUTH: 
            case NORTH: {
                bb.maxZ = 1.0 - twoPixels;
                bb.minZ = 0.0 + twoPixels;
                break;
            }
            case WEST: 
            case EAST: {
                bb.minX = 0.0 + twoPixels;
                bb.maxX = 1.0 - twoPixels;
                break;
            }
        }
        return Shapes.create((AABB)bb.getBoundingBox());
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }
}

