/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.hooks;

import appeng.api.parts.IPart;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.items.tools.quartz.QuartzCuttingKnifeItem;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.util.InteractionUtil;
import com.glodblock.github.extendedae.container.ContainerRenamer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public final class CutterHook {
    public static final CutterHook INSTANCE = new CutterHook();

    private CutterHook() {
    }

    @SubscribeEvent
    public void onPlayerUseBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        if (event.getUseBlock() == Event.Result.DENY) {
            return;
        }
        InteractionResult result = this.onPlayerUseBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
        if (result != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    public InteractionResult onPlayerUseBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos pos;
        BlockEntity tile;
        if (player.isSpectator() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (!InteractionUtil.isInAlternateUseMode((Player)player) && itemStack.getItem() instanceof QuartzCuttingKnifeItem && (tile = level.getBlockEntity(pos = hitResult.getBlockPos())) instanceof AEBaseBlockEntity) {
            if (tile instanceof CableBusBlockEntity) {
                CableBusBlockEntity cable = (CableBusBlockEntity)tile;
                Vec3 hitVec = hitResult.getLocation();
                Vec3 hitInBlock = new Vec3(hitVec.x - (double)pos.getX(), hitVec.y - (double)pos.getY(), hitVec.z - (double)pos.getZ());
                IPart part = cable.selectPartLocal((Vec3)hitInBlock).part;
                if (part instanceof AEBasePart) {
                    AEBasePart p = (AEBasePart)part;
                    if (!level.isClientSide) {
                        MenuOpener.open(ContainerRenamer.TYPE, (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)p));
                    }
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            } else {
                if (!level.isClientSide) {
                    MenuOpener.open(ContainerRenamer.TYPE, (Player)player, (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)tile));
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }
}

