/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.items.AEBaseItem;
import appeng.items.storage.StorageCellTooltipComponent;
import com.glodblock.github.extendedae.common.EAEItemAndBlock;
import com.glodblock.github.extendedae.config.EAEConfig;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class InfinityCell
extends AEBaseItem
implements ICellWorkbenchItem {
    public InfinityCell() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public AEKey getRecord(ItemStack stack) {
        AEKey key;
        CompoundTag tag = stack.getTag();
        if (tag != null && (key = AEKey.fromTagGeneric((CompoundTag)tag.getCompound("record"))) != null) {
            return key;
        }
        return AEFluidKey.of((Fluid)Fluids.WATER);
    }

    public ItemStack getRecordCell(AEKey record) {
        ItemStack stack = new ItemStack((ItemLike)EAEItemAndBlock.INFINITY_CELL);
        CompoundTag tag = new CompoundTag();
        tag.put("record", (Tag)record.toTagGeneric());
        stack.setTag(tag);
        return stack;
    }

    @NotNull
    public Component getName(@NotNull ItemStack is) {
        return Component.translatable((String)"item.extendedae.infinity_cell_name", (Object[])new Object[]{this.getRecord(is).getDisplayName()});
    }

    public void addToMainCreativeTab(CreativeModeTab.Output output) {
        EAEConfig.infCellFluid.forEach(f -> output.accept(this.getRecordCell((AEKey)AEFluidKey.of((Fluid)f))));
        EAEConfig.infCellItem.forEach(i -> output.accept(this.getRecordCell((AEKey)AEItemKey.of((ItemLike)i))));
    }

    public void appendHoverText(@NotNull ItemStack is, Level world, @NotNull List<Component> lines, @NotNull TooltipFlag adv) {
        lines.add((Component)Component.translatable((String)"infinity.tooltip").withStyle(ChatFormatting.GREEN));
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        List<GenericStack> content = Collections.singletonList(new GenericStack(this.getRecord(stack), InfinityCell.getAsIntMax(this.getRecord(stack))));
        return Optional.of(new StorageCellTooltipComponent(List.of(), content, false, true));
    }

    public FuzzyMode getFuzzyMode(ItemStack itemStack) {
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack itemStack, FuzzyMode fuzzyMode) {
    }

    public static long getAsIntMax(AEKey key) {
        if (key instanceof AEFluidKey) {
            return 2147483647000L;
        }
        return Integer.MAX_VALUE;
    }
}

