/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items;

import appeng.api.parts.IPart;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.util.Platform;
import com.glodblock.github.extendedae.common.EAEItemAndBlock;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ItemMEPackingTape
extends Item {
    private static final ObjectSet<ResourceLocation> WHITE_LIST = new ObjectOpenHashSet();

    public ItemMEPackingTape() {
        super(new Item.Properties().durability(64));
    }

    @Nonnull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        BlockEntity tile = world.getBlockEntity(pos);
        Player player = context.getPlayer();
        if (tile != null && player != null) {
            CompoundTag tag = new CompoundTag();
            if (tile instanceof CableBusBlockEntity) {
                CableBusBlockEntity cable = (CableBusBlockEntity)tile;
                Vec3 hitVec = context.getClickLocation();
                Vec3 hitInBlock = new Vec3(hitVec.x - (double)pos.getX(), hitVec.y - (double)pos.getY(), hitVec.z - (double)pos.getZ());
                IPart part = cable.getCableBus().selectPartLocal((Vec3)hitInBlock).part;
                if (part != null) {
                    tag.putBoolean("part", true);
                    Item partItem = part.getPartItem().asItem();
                    ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)partItem);
                    if (!WHITE_LIST.contains((Object)id)) {
                        return InteractionResult.PASS;
                    }
                    tag.putString("id", id.toString());
                    CompoundTag ctxTag = new CompoundTag();
                    part.writeToNBT(ctxTag);
                    tag.put("ctx", (Tag)ctxTag);
                    cable.removePart(part);
                }
            } else {
                tag.putBoolean("part", false);
                BlockState state = tile.getBlockState();
                ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
                if (!WHITE_LIST.contains((Object)blockId)) {
                    return InteractionResult.PASS;
                }
                ResourceLocation id = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)tile.getType());
                assert (id != null);
                tag.putString("id", id.toString());
                tag.putString("block_id", blockId.toString());
                tag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)state));
                CompoundTag ctxTag = tile.serializeNBT();
                tag.put("ctx", (Tag)ctxTag);
                world.removeBlockEntity(pos);
                world.removeBlock(pos, false);
            }
            if (!tag.isEmpty()) {
                ItemStack pack = new ItemStack((ItemLike)EAEItemAndBlock.PACKAGE);
                pack.setTag(tag);
                Platform.spawnDrops((Level)world, (BlockPos)pos, Collections.singletonList(pack));
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, e -> e.broadcastBreakEvent(context.getHand()));
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public static void registerPackableDevice(ResourceLocation id) {
        WHITE_LIST.add((Object)id);
    }
}

