/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.items.AEBaseItem;
import appeng.parts.PartPlacement;
import appeng.util.Platform;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ItemPackedDevice
extends AEBaseItem {
    public ItemPackedDevice() {
        super(new Item.Properties().stacksTo(1));
    }

    public void addToMainCreativeTab(CreativeModeTab.Output output) {
    }

    public void appendHoverText(@NotNull ItemStack is, Level world, @NotNull List<Component> lines, @NotNull TooltipFlag adv) {
        if (is.hasTag()) {
            CompoundTag tag = is.getTag();
            assert (tag != null);
            if (this.checkNBT(tag)) {
                if (tag.getBoolean("part")) {
                    Item item = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(tag.getString("id")));
                    if (item != Items.AIR) {
                        Component name = new ItemStack((ItemLike)item).getDisplayName();
                        lines.add((Component)Component.translatable((String)"packaged_device.tooltip", (Object[])new Object[]{name}).withStyle(ChatFormatting.GRAY));
                        return;
                    }
                } else {
                    Block item = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(tag.getString("block_id")));
                    if (item != Blocks.AIR) {
                        Component name = new ItemStack((ItemLike)item).getDisplayName();
                        lines.add((Component)Component.translatable((String)"packaged_device.tooltip", (Object[])new Object[]{name}).withStyle(ChatFormatting.GRAY));
                        return;
                    }
                }
            }
        }
        lines.add((Component)Component.translatable((String)"packaged_device.error.tooltip").withStyle(ChatFormatting.RED));
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        BlockState state;
        Item item;
        Direction side = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        ItemStack pack = context.getItemInHand();
        if (!pack.hasTag()) {
            return InteractionResult.FAIL;
        }
        CompoundTag ctx = pack.getTag();
        assert (ctx != null);
        if (!this.checkNBT(ctx)) {
            return InteractionResult.FAIL;
        }
        if (ctx.getBoolean("part")) {
            Item item2 = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(ctx.getString("id")));
            if (item2 instanceof IPartItem) {
                IPartItem partItem = (IPartItem)item2;
                PartPlacement.Placement placement = PartPlacement.getPartPlacement((Player)context.getPlayer(), (Level)world, (ItemStack)new ItemStack((ItemLike)partItem), (BlockPos)pos, (Direction)side, (Vec3)context.getClickLocation());
                if (placement != null) {
                    IPart part = PartPlacement.placePart((Player)context.getPlayer(), (Level)world, (IPartItem)partItem, null, (BlockPos)placement.pos(), (Direction)placement.side());
                    if (part != null) {
                        part.readFromNBT(ctx.getCompound("ctx"));
                        pack.shrink(1);
                        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
                    }
                    Platform.sendImmediateBlockEntityUpdate((Player)context.getPlayer(), (BlockPos)pos);
                }
            }
            return InteractionResult.PASS;
        }
        BlockEntityType block = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(new ResourceLocation(ctx.getString("id")));
        if (block != null && (item = (state = NbtUtils.readBlockState((HolderGetter)world.holderLookup(Registries.BLOCK), (CompoundTag)ctx.getCompound("state"))).getBlock().asItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (context.getPlayer() != null) {
                BlockPos posNew;
                BlockEntity te;
                BlockPlaceContext ctxB = new BlockPlaceContext(world, context.getPlayer(), context.getHand(), new ItemStack((ItemLike)blockItem), context.hitResult);
                if ((ctxB = blockItem.updatePlacementContext(ctxB)) != null && blockItem.place(ctxB) != InteractionResult.FAIL && (te = block.create(posNew = ctxB.getClickedPos(), state)) != null) {
                    world.setBlock(posNew, state, 3);
                    world.setBlockEntity(te);
                    te.deserializeNBT(ctx.getCompound("ctx"));
                    if (te instanceof AEBaseBlockEntity) {
                        AEBaseBlockEntity aeTile = (AEBaseBlockEntity)te;
                        aeTile.markForUpdate();
                    } else {
                        te.setChanged();
                    }
                    pack.shrink(1);
                    return InteractionResult.sidedSuccess((boolean)world.isClientSide);
                }
            }
        }
        return InteractionResult.PASS;
    }

    private boolean checkNBT(CompoundTag content) {
        return content.contains("part") && content.contains("id") && content.contains("ctx");
    }
}

