/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.parts.AEBasePart;
import com.glodblock.github.extendedae.util.FCUtil;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public abstract class ItemUpgrade
extends Item {
    private final HashMap<Class<? extends BlockEntity>, TileEntityPair> BLOCK_MAP = new HashMap();
    private final HashMap<Class<? extends IPart>, IPartItem<?>> PART_MAP = new HashMap();

    public ItemUpgrade(Item.Properties properties) {
        super(properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile == null) return InteractionResult.PASS;
        BlockPlaceContext ctx = new BlockPlaceContext(context);
        Class<?> tClazz = tile.getClass();
        if (this.BLOCK_MAP.containsKey(tClazz)) {
            BlockState originState = world.getBlockState(pos);
            TileEntityPair replaceInfo = this.BLOCK_MAP.get(tClazz);
            BlockState state = replaceInfo.block.getStateForPlacement(ctx);
            BlockEntityType tileType = GlodUtil.getTileType(replaceInfo.tile);
            if (state == null) {
                return InteractionResult.PASS;
            }
            for (Map.Entry sp : originState.getValues().entrySet()) {
                Property pt = (Property)sp.getKey();
                Comparable va = (Comparable)sp.getValue();
                try {
                    if (!state.hasProperty(pt)) continue;
                    state = (BlockState)state.setValue(pt, va);
                }
                catch (Exception exception) {}
            }
            BlockEntity te = tileType.create(pos, state);
            FCUtil.replaceTile(world, pos, tile, te, state);
            context.getItemInHand().shrink(1);
            return InteractionResult.CONSUME;
        }
        if (!(tile instanceof CableBusBlockEntity)) return InteractionResult.PASS;
        CableBusBlockEntity cable = (CableBusBlockEntity)tile;
        Vec3 hitVec = context.getClickLocation();
        Vec3 hitInBlock = new Vec3(hitVec.x - (double)pos.getX(), hitVec.y - (double)pos.getY(), hitVec.z - (double)pos.getZ());
        IPart part = cable.getCableBus().selectPartLocal((Vec3)hitInBlock).part;
        if (!(part instanceof AEBasePart)) return InteractionResult.PASS;
        AEBasePart basePart = (AEBasePart)part;
        if (!this.PART_MAP.containsKey(part.getClass())) return InteractionResult.PASS;
        Direction side = basePart.getSide();
        CompoundTag contents = new CompoundTag();
        IPartItem<?> partItem = this.PART_MAP.get(part.getClass());
        part.writeToNBT(contents);
        IPart p = cable.replacePart(partItem, side, context.getPlayer(), null);
        if (p != null) {
            p.readFromNBT(contents);
        }
        context.getItemInHand().shrink(1);
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    protected void addTile(Class<? extends BlockEntity> clazz, Block block, Class<? extends BlockEntity> tile) {
        this.BLOCK_MAP.put(clazz, new TileEntityPair(block, tile));
    }

    protected void addPart(Class<? extends IPart> clazz, IPartItem<?> item) {
        this.PART_MAP.put(clazz, item);
    }

    private record TileEntityPair(Block block, Class<? extends BlockEntity> tile) {
    }
}

