/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items;

import appeng.util.InteractionUtil;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.common.EAEItemAndBlock;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ItemWirelessConnectTool
extends Item {
    public ItemWirelessConnectTool() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(@NotNull ItemStack stack, Level world, @NotNull List<Component> lines, @NotNull TooltipFlag adv) {
        BlockPos pos;
        CompoundTag nbt;
        CompoundTag compoundTag = nbt = stack.hasTag() ? stack.getTag() : new CompoundTag();
        assert (nbt != null);
        long freq = nbt.getLong("freq");
        GlobalPos globalPos = nbt.contains("bind") ? (GlobalPos)GlobalPos.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("bind")).resultOrPartial(Util.prefix((String)"Connector position", arg_0 -> ((Logger)ExtendedAE.LOGGER).error(arg_0))).map(Pair::getFirst).orElse(null) : null;
        BlockPos blockPos = pos = globalPos != null ? globalPos.pos() : BlockPos.ZERO;
        if (freq != 0L) {
            lines.add((Component)Component.translatable((String)"wireless.tooltip", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.GRAY));
            lines.add((Component)Component.translatable((String)"wireless.use.tooltip.02").withStyle(ChatFormatting.GRAY));
        } else {
            lines.add((Component)Component.translatable((String)"wireless.use.tooltip.01").withStyle(ChatFormatting.GRAY));
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (InteractionUtil.isInAlternateUseMode((Player)player) && stack.getItem() == EAEItemAndBlock.WIRELESS_TOOL) {
            stack.setTag(null);
            player.displayClientMessage((Component)Component.translatable((String)"chat.wireless_connect.clear"), true);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

