/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.IStackWatcher;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingWatcherNode;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.core.definitions.AEItems;
import appeng.helpers.IConfigInvHost;
import appeng.hooks.ticking.TickHandler;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.automation.AbstractLevelEmitterPart;
import appeng.util.ConfigInventory;
import appeng.util.SettingsFrom;
import com.glodblock.github.extendedae.container.ContainerThresholdLevelEmitter;
import com.glodblock.github.extendedae.util.Ae2Reflect;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PartThresholdLevelEmitter
extends AbstractLevelEmitterPart
implements IConfigInvHost {
    public static List<ResourceLocation> MODELS = Arrays.asList(new ResourceLocation("extendedae", "part/threshold_level_emitter_base_off"), new ResourceLocation("extendedae", "part/threshold_level_emitter_base_on"), new ResourceLocation("ae2", "part/level_emitter_status_off"), new ResourceLocation("ae2", "part/level_emitter_status_on"), new ResourceLocation("ae2", "part/level_emitter_status_has_channel"));
    public static final PartModel MODEL_OFF_OFF = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(2)});
    public static final PartModel MODEL_OFF_ON = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(3)});
    public static final PartModel MODEL_OFF_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(4)});
    public static final PartModel MODEL_ON_OFF = new PartModel(new ResourceLocation[]{MODELS.get(1), MODELS.get(2)});
    public static final PartModel MODEL_ON_ON = new PartModel(new ResourceLocation[]{MODELS.get(1), MODELS.get(3)});
    public static final PartModel MODEL_ON_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODELS.get(1), MODELS.get(4)});
    private final ConfigInventory config = ConfigInventory.configTypes((int)1).changeListener(this::configureWatchers).build();
    private IStackWatcher storageWatcher;
    private IStackWatcher craftingWatcher;
    private long lastUpdateTick = -1L;
    private long upperValue;
    private long lowerValue;

    public PartThresholdLevelEmitter(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().addService(IStorageWatcherNode.class, (IGridNodeService)new IStorageWatcherNode(){

            public void updateWatcher(IStackWatcher newWatcher) {
                PartThresholdLevelEmitter.this.storageWatcher = newWatcher;
                PartThresholdLevelEmitter.this.configureWatchers();
            }

            public void onStackChange(AEKey what, long amount) {
                if (what.equals(PartThresholdLevelEmitter.this.getConfiguredKey()) && !PartThresholdLevelEmitter.this.isUpgradedWith((ItemLike)AEItems.FUZZY_CARD)) {
                    PartThresholdLevelEmitter.this.lastReportedValue = amount;
                    PartThresholdLevelEmitter.this.updateState();
                } else {
                    long currentTick = TickHandler.instance().getCurrentTick();
                    if (currentTick != PartThresholdLevelEmitter.this.lastUpdateTick) {
                        PartThresholdLevelEmitter.this.lastUpdateTick = currentTick;
                        PartThresholdLevelEmitter.this.getMainNode().ifPresent(PartThresholdLevelEmitter.this::updateReportingValue);
                    }
                }
            }
        });
        this.getMainNode().addService(ICraftingWatcherNode.class, (IGridNodeService)new ICraftingWatcherNode(){

            public void updateWatcher(IStackWatcher newWatcher) {
                PartThresholdLevelEmitter.this.craftingWatcher = newWatcher;
                PartThresholdLevelEmitter.this.configureWatchers();
            }

            public void onRequestChange(AEKey what) {
                PartThresholdLevelEmitter.this.updateState();
            }

            public void onCraftableChange(AEKey what) {
            }
        });
        this.getConfigManager().registerSetting(Settings.CRAFT_VIA_REDSTONE, (Enum)YesNo.NO);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
    }

    @Nullable
    private AEKey getConfiguredKey() {
        return this.config.getKey(0);
    }

    protected final int getUpgradeSlots() {
        return 1;
    }

    protected boolean hasDirectOutput() {
        return false;
    }

    protected boolean getDirectOutput() {
        return false;
    }

    protected void onReportingValueChanged() {
        this.getMainNode().ifPresent(this::updateReportingValue);
    }

    protected void configureWatchers() {
        AEKey myStack = this.getConfiguredKey();
        if (this.storageWatcher != null) {
            this.storageWatcher.reset();
        }
        if (this.craftingWatcher != null) {
            this.craftingWatcher.reset();
        }
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
        if (this.isUpgradedWith((ItemLike)AEItems.CRAFTING_CARD)) {
            if (this.craftingWatcher != null) {
                if (myStack == null) {
                    this.craftingWatcher.setWatchAll(true);
                } else {
                    this.craftingWatcher.add(myStack);
                }
            }
        } else {
            if (this.storageWatcher != null) {
                if (this.isUpgradedWith((ItemLike)AEItems.FUZZY_CARD) || myStack == null) {
                    this.storageWatcher.setWatchAll(true);
                } else {
                    this.storageWatcher.add(myStack);
                }
            }
            this.getMainNode().ifPresent(this::updateReportingValue);
        }
        this.updateState();
    }

    public boolean checkSanity() {
        return this.lowerValue <= this.upperValue;
    }

    public boolean checkState(long value, boolean invert) {
        boolean current;
        boolean bl = current = invert != Ae2Reflect.getPrevState(this);
        if (current) {
            return value >= this.lowerValue;
        }
        return value >= this.upperValue;
    }

    protected boolean isLevelEmitterOn() {
        if (this.isClientSide()) {
            return super.isLevelEmitterOn();
        }
        if (!this.getMainNode().isActive()) {
            return false;
        }
        if (!this.checkSanity()) {
            return false;
        }
        boolean flipState = this.getConfigManager().getSetting(Settings.REDSTONE_EMITTER) == RedstoneMode.LOW_SIGNAL;
        boolean active = this.checkState(this.lastReportedValue, flipState);
        return flipState != active;
    }

    private void updateReportingValue(IGrid grid) {
        KeyCounter stacks = grid.getStorageService().getCachedInventory();
        AEKey myStack = this.getConfiguredKey();
        if (myStack == null) {
            this.lastReportedValue = 0L;
            for (Object2LongMap.Entry st : stacks) {
                this.lastReportedValue += st.getLongValue();
                if (this.lastReportedValue <= this.getUpperValue()) continue;
                break;
            }
        } else if (this.isUpgradedWith((ItemLike)AEItems.FUZZY_CARD)) {
            this.lastReportedValue = 0L;
            FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
            Collection fuzzyList = stacks.findFuzzy(myStack, fzMode);
            for (Object2LongMap.Entry st : fuzzyList) {
                this.lastReportedValue += st.getLongValue();
                if (this.lastReportedValue <= this.getUpperValue()) continue;
                break;
            }
        } else {
            this.lastReportedValue = stacks.get(myStack);
        }
        this.updateState();
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (!this.isClientSide()) {
            MenuOpener.open(ContainerThresholdLevelEmitter.TYPE, (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public ConfigInventory getConfig() {
        return this.config;
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return this.isLevelEmitterOn() ? MODEL_ON_HAS_CHANNEL : MODEL_OFF_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return this.isLevelEmitterOn() ? MODEL_ON_ON : MODEL_OFF_ON;
        }
        return this.isLevelEmitterOn() ? MODEL_ON_OFF : MODEL_OFF_OFF;
    }

    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.upperValue = data.getLong("upperValue");
        this.lowerValue = data.getLong("lowerValue");
        this.config.readFromChildTag(data, "config");
    }

    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.putLong("upperValue", this.upperValue);
        data.putLong("lowerValue", this.lowerValue);
        this.config.writeToChildTag(data, "config");
    }

    public void setUpperValue(long value) {
        this.upperValue = value;
        this.onReportingValueChanged();
        this.updateState();
    }

    public void setLowerValue(long value) {
        this.lowerValue = value;
        this.onReportingValueChanged();
        this.updateState();
    }

    public long getUpperValue() {
        return this.upperValue;
    }

    public long getLowerValue() {
        return this.lowerValue;
    }

    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        this.setUpperValue(input.getLong("upperValue"));
        this.setLowerValue(input.getLong("lowerValue"));
    }

    public void exportSettings(SettingsFrom mode, CompoundTag output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            output.putLong("upperValue", this.upperValue);
            output.putLong("lowerValue", this.lowerValue);
        }
    }
}

