/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.AEItemFilters;
import com.glodblock.github.extendedae.api.IRecipeMachine;
import com.glodblock.github.extendedae.common.EAEItemAndBlock;
import com.glodblock.github.extendedae.recipe.CircuitCutterRecipe;
import com.glodblock.github.extendedae.recipe.util.IngredientStack;
import com.glodblock.github.extendedae.util.FCUtil;
import com.glodblock.github.extendedae.util.recipe.ContainerRecipeContext;
import com.glodblock.github.extendedae.util.recipe.RecipeExecutor;
import com.glodblock.github.extendedae.util.recipe.RecipeSearchContext;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TileCircuitCutter
extends AENetworkPowerBlockEntity
implements IGridTickable,
IUpgradeableObject,
IConfigurableObject,
IRecipeMachine<Container, CircuitCutterRecipe> {
    public static final int POWER_MAXIMUM_AMOUNT = 8000;
    public static final int MAX_PROGRESS = 200;
    private final AppEngInternalInventory input = new AppEngInternalInventory((InternalInventoryHost)this, 1, 64);
    private final AppEngInternalInventory output = new AppEngInternalInventory((InternalInventoryHost)this, 1, 64);
    private final CombinedInternalInventory inv = new CombinedInternalInventory(new InternalInventory[]{this.input, this.output});
    private final FilteredInternalInventory outputExposed = new FilteredInternalInventory((InternalInventory)this.output, AEItemFilters.EXTRACT_ONLY);
    private final FilteredInternalInventory inputExposed = new FilteredInternalInventory((InternalInventory)this.input, AEItemFilters.INSERT_ONLY);
    private final CombinedInternalInventory invExposed = new CombinedInternalInventory(new InternalInventory[]{this.inputExposed, this.outputExposed});
    private final ContainerRecipeContext<CircuitCutterRecipe> ctx = new CutterRecipeContext(this);
    private final RecipeExecutor<CircuitCutterRecipe> exec;
    private final IUpgradeInventory upgrades;
    private final ConfigManager configManager;
    private boolean isWorking = false;
    private int progress = 0;
    private ItemStack renderOutput = ItemStack.EMPTY;

    public TileCircuitCutter(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileCircuitCutter.class, TileCircuitCutter::new, (Block)EAEItemAndBlock.CIRCUIT_CUTTER), pos, blockState);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(8000.0);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
        this.upgrades = UpgradeInventories.forMachine((ItemLike)EAEItemAndBlock.CIRCUIT_CUTTER, (int)4, () -> ((TileCircuitCutter)this).saveChanges());
        this.configManager = new ConfigManager(this::onConfigChanged);
        this.configManager.registerSetting(Settings.AUTO_EXPORT, (Enum)YesNo.NO);
        this.exec = new RecipeExecutor<CircuitCutterRecipe>(this, r -> r.output, 200);
    }

    protected InternalInventory getExposedInventoryForSide(Direction facing) {
        return this.invExposed;
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void addProgress(int delta) {
        this.progress += delta;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public RecipeSearchContext<Container, CircuitCutterRecipe> getContext() {
        return this.ctx;
    }

    @Override
    public void setWorking(boolean work) {
        this.isWorking = work;
    }

    public AppEngInternalInventory getInput() {
        return this.input;
    }

    public AppEngInternalInventory getOutput() {
        return this.output;
    }

    public ItemStack getRenderOutput() {
        return this.renderOutput;
    }

    @Override
    @Nullable
    public IManagedGridNode getNode() {
        return this.getMainNode();
    }

    @Override
    @Nullable
    public IEnergySource getEnergy() {
        return this;
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.complementOf(EnumSet.of(orientation.getSide(RelativeSide.FRONT), orientation.getSide(RelativeSide.BACK)));
    }

    private void onConfigChanged(IConfigManager manager, Setting<?> setting) {
        if (setting == Settings.AUTO_EXPORT) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        }
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        super.readFromStream(data);
        this.isWorking = data.readBoolean();
        this.progress = data.readInt();
        this.input.setItemDirect(0, data.readItem());
        this.renderOutput = data.readItem();
        return true;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isWorking);
        data.writeInt(this.progress);
        data.writeItem(this.input.getStackInSlot(0));
        this.renderOutput = this.ctx.currentRecipe == null ? ItemStack.EMPTY : ((CircuitCutterRecipe)this.ctx.currentRecipe.value()).output;
        data.writeItem(this.renderOutput);
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    public void saveAdditional(CompoundTag data) {
        super.saveAdditional(data);
        this.upgrades.writeToNBT(data, "upgrades");
        this.configManager.writeToNBT(data);
        this.ctx.save(data);
    }

    public void clearContent() {
        super.clearContent();
        this.upgrades.clear();
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.configManager.readFromNBT(data);
        this.ctx.load(data);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    private boolean hasAutoExportWork() {
        return !this.output.getStackInSlot(0).isEmpty() && this.configManager.getSetting(Settings.AUTO_EXPORT) == YesNo.YES;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber, !this.ctx.shouldTick() && !this.hasAutoExportWork());
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.pushOutResult()) {
            return TickRateModulation.URGENT;
        }
        this.markForUpdate();
        return this.exec.execute(FCUtil.speedCardMap(this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD)), true);
    }

    private boolean pushOutResult() {
        if (!this.hasAutoExportWork()) {
            return false;
        }
        return FCUtil.ejectInv(this.level, this.getBlockPos(), (InternalInventory)this.output);
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        this.saveChanges();
        this.ctx.onInvChange();
    }

    private static class CutterRecipeContext
    extends ContainerRecipeContext<CircuitCutterRecipe> {
        private final TileCircuitCutter host;

        protected CutterRecipeContext(TileCircuitCutter host) {
            super(() -> host.level, CircuitCutterRecipe.TYPE);
            this.host = host;
        }

        @Override
        public void onInvChange() {
            super.onInvChange();
            this.host.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        }

        @Override
        public void onFind(@Nullable RecipeHolder<CircuitCutterRecipe> recipe) {
            super.onFind(recipe);
            this.host.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        }

        @Override
        public boolean testRecipe(RecipeHolder<CircuitCutterRecipe> recipe) {
            List<IngredientStack<?>> sample = ((CircuitCutterRecipe)recipe.value()).getSample();
            List<ItemStack> copyInv = this.copyHostInv();
            for (IngredientStack<?> tester : sample) {
                for (ItemStack stack : copyInv) {
                    if (tester.checkType(stack)) {
                        tester.consume(stack);
                    }
                    if (!tester.isEmpty()) continue;
                    break;
                }
                if (!tester.isEmpty()) {
                    return false;
                }
                copyInv = copyInv.stream().filter(o -> !o.isEmpty()).toList();
            }
            return true;
        }

        @Override
        public void runRecipe(RecipeHolder<CircuitCutterRecipe> recipe) {
            List<IngredientStack<?>> sample = ((CircuitCutterRecipe)recipe.value()).getSample();
            block0: for (IngredientStack<?> tester : sample) {
                for (int x = 0; x < this.host.input.size(); ++x) {
                    ItemStack item = this.host.input.getStackInSlot(x);
                    if (tester.checkType(item)) {
                        tester.consume(item);
                        this.host.input.setItemDirect(x, item);
                    }
                    if (tester.isEmpty()) continue block0;
                }
            }
        }

        public List<ItemStack> copyHostInv() {
            ArrayList<ItemStack> inv = new ArrayList<ItemStack>();
            for (ItemStack item : this.host.input) {
                if (item.isEmpty()) continue;
                inv.add(item.copy());
            }
            return inv;
        }
    }
}

