/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import com.glodblock.github.extendedae.api.ExtendedAEAPI;
import com.glodblock.github.extendedae.api.ICrystalFixer;
import com.glodblock.github.extendedae.common.EAEItemAndBlock;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TileCrystalFixer
extends AENetworkInvBlockEntity
implements IGridTickable {
    private final AppEngInternalInventory inv = new AppEngInternalInventory((InternalInventoryHost)this, 1);
    private int progress = 0;

    public TileCrystalFixer(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileCrystalFixer.class, TileCrystalFixer::new, (Block)EAEItemAndBlock.CRYSTAL_FIXER), pos, blockState);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.inv.setFilter((IAEItemFilter)new Filter());
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(2, 10, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.doWork(ticksSinceLastCall)) {
            return TickRateModulation.FASTER;
        }
        return TickRateModulation.SLOWER;
    }

    private boolean canFixCrystal(BlockState blockState) {
        for (ICrystalFixer fixer : ExtendedAEAPI.INSTANCE.getCrystalFixers()) {
            if (!fixer.isCrystal(blockState.getBlock()) || !fixer.canFix(blockState, this.inv.getStackInSlot(0))) continue;
            return true;
        }
        return false;
    }

    private Block getNextCrystalBlock(BlockState crystal) {
        for (ICrystalFixer fixer : ExtendedAEAPI.INSTANCE.getCrystalFixers()) {
            if (!fixer.isCrystal(crystal.getBlock())) continue;
            return fixer.getNextCrystalBlock(crystal);
        }
        return null;
    }

    private boolean doWork(int ticksSinceLastCall) {
        if (this.getLevel() == null || !this.checkFuel()) {
            return false;
        }
        BlockPos blockPos = this.getBlockPos().offset(this.getFront().getNormal());
        BlockState blockState = this.getLevel().getBlockState(blockPos);
        RandomSource random = this.getLevel().getRandom();
        if (this.canFixCrystal(blockState)) {
            if (this.userPower(ticksSinceLastCall * 50) > 0L) {
                this.progress += random.nextInt(5);
                this.consumeFuel(random);
            }
            if (this.progress >= 100) {
                Block block = this.getNextCrystalBlock(blockState);
                if (block != null) {
                    this.getLevel().setBlockAndUpdate(blockPos, block.defaultBlockState());
                }
                this.progress = 0;
            }
            return true;
        }
        this.progress = 0;
        return false;
    }

    private boolean checkFuel() {
        return !this.inv.getStackInSlot(0).isEmpty();
    }

    private void consumeFuel(RandomSource random) {
        if (random.nextInt(10) < 1) {
            this.inv.extractItem(0, 1, false);
        }
    }

    public int getProgress() {
        return this.progress;
    }

    private long userPower(int value) {
        if (this.getGridNode() == null) {
            return 0L;
        }
        IGrid grid = this.getGridNode().getGrid();
        if (grid != null) {
            return (long)grid.getEnergyService().extractAEPower((double)value, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
        return 0L;
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        this.inv.setItemDirect(0, data.readItem());
        return changed;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeItem(this.inv.getStackInSlot(0));
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.of(orientation.getSide(RelativeSide.BACK));
    }

    public void saveAdditional(CompoundTag data) {
        super.saveAdditional(data);
        data.putInt("progress", this.progress);
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.progress = data.getInt("progress");
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        this.markForUpdate();
    }

    public void refuel(Player player) {
        if (!Platform.hasPermissions((DimensionalBlockPos)new DimensionalBlockPos((BlockEntity)this), (Player)player)) {
            return;
        }
        Inventory playerInv = player.getInventory();
        ItemStack held = playerInv.getSelected();
        if (held.isEmpty()) {
            ItemStack stuff = this.inv.extractItem(0, Integer.MAX_VALUE, false);
            if (!stuff.isEmpty()) {
                playerInv.placeItemBackInInventory(stuff);
            }
        } else {
            ItemStack notAdded = this.inv.insertItem(0, held, false);
            playerInv.setItem(playerInv.selected, notAdded);
        }
    }

    private static class Filter
    implements IAEItemFilter {
        private Filter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            for (ICrystalFixer fixer : ExtendedAEAPI.INSTANCE.getCrystalFixers()) {
                if (!fixer.getFuelType().equals(stack.getItem())) continue;
                return true;
            }
            return false;
        }
    }
}

