/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.config;

import com.glodblock.github.extendedae.util.FCUtil;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@Mod.EventBusSubscriber(modid="extendedae", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EAEConfig {
    private static IntList defaultModifierMultiplier = new IntImmutableList(new int[]{2, 3, 5, 7});
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.IntValue EX_BUS_SPEED = BUILDER.comment("ME Extend Import/Export Bus speed multiplier").defineInRange("exBusMultiplier", 8, 2, 128);
    private static final ModConfigSpec.DoubleValue INFINITY_CELL_ENERGY = BUILDER.comment("ME Infinity Cell idle energy cost (unit: AE/t)").defineInRange("cost", 8.0, 0.1, 64.0);
    private static final ModConfigSpec.DoubleValue WIRELESS_CONNECTOR_RANGE = BUILDER.comment("The max range between two wireless connector").defineInRange("range", 1000.0, 10.0, 10000.0);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> INFINITY_CELL_TYPES = BUILDER.comment("ME Infinity Cell types (item or fluid's id)").defineList("types", (List)Lists.newArrayList((Object[])new String[]{"minecraft:water", "minecraft:cobblestone"}), EAEConfig::checkRL);
    private static final ModConfigSpec.ConfigValue<List<? extends Integer>> PATTERN_MODIFIER_NUMBER = BUILDER.comment("Pattern modifier multipliers").defineList("modifierMultipliers", (List)defaultModifierMultiplier, EAEConfig::checkPositive);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> PACKABLE_AE_DEVICE = BUILDER.comment("The AE device/part that can be packed by ME Packing Tape").defineList("whitelist", (List)Lists.newArrayList((Object[])new String[]{"extendedae:ex_interface_part", "extendedae:ex_pattern_provider_part", "extendedae:ex_interface", "extendedae:ex_pattern_provider", "extendedae:ex_drive", "ae2:cable_interface", "ae2:cable_pattern_provider", "ae2:interface", "ae2:pattern_provider", "ae2:drive"}), o -> true);
    private static final ModConfigSpec.BooleanValue INSCRIBER_RENDER = BUILDER.comment("Disable Extended Inscriber's item render, it only works in client side.").define("disableItemRender", false);
    private static final ModConfigSpec.IntValue OVERSIZE_MULTIPLIER = BUILDER.comment("Size multiplier of oversize interface").defineInRange("oversizeMultiplier", 16, 2, 4096);
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static int busSpeed;
    public static double infCellCost;
    public static double wirelessMaxRange;
    public static List<Fluid> infCellFluid;
    public static List<Item> infCellItem;
    public static List<ResourceLocation> tapeWhitelist;
    public static boolean disableInscriberRender;
    public static int oversizeMultiplier;
    private static List<? extends Integer> modifierMultiplier;

    private static boolean checkRL(Object o) {
        String s;
        return o instanceof String && (FCUtil.checkInvalidRL(s = (String)o, BuiltInRegistries.ITEM) || FCUtil.checkInvalidRL(s, BuiltInRegistries.FLUID));
    }

    private static boolean checkPositive(Object o) {
        return o instanceof Integer && (Integer)o > 0;
    }

    public static int getPatternModifierNumber(int index) {
        if (index >= modifierMultiplier.size()) {
            return defaultModifierMultiplier.getInt(index);
        }
        return modifierMultiplier.get(index);
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        busSpeed = (Integer)EX_BUS_SPEED.get();
        infCellCost = (Double)INFINITY_CELL_ENERGY.get();
        wirelessMaxRange = (Double)WIRELESS_CONNECTOR_RANGE.get();
        infCellFluid = new ArrayList<Fluid>();
        infCellItem = new ArrayList<Item>();
        ((List)INFINITY_CELL_TYPES.get()).forEach(s -> {
            if (FCUtil.checkInvalidRL(s, BuiltInRegistries.ITEM)) {
                infCellItem.add((Item)BuiltInRegistries.ITEM.get(new ResourceLocation(s)));
            }
            if (FCUtil.checkInvalidRL(s, BuiltInRegistries.FLUID)) {
                infCellFluid.add((Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(s)));
            }
        });
        tapeWhitelist = ((List)PACKABLE_AE_DEVICE.get()).stream().map(ResourceLocation::new).collect(Collectors.toList());
        disableInscriberRender = (Boolean)INSCRIBER_RENDER.get();
        oversizeMultiplier = (Integer)OVERSIZE_MULTIPLIER.get();
        modifierMultiplier = (List)PATTERN_MODIFIER_NUMBER.get();
    }
}

