/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.core.localization.Tooltips;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.OutputSlot;
import appeng.util.ConfigMenuInventory;
import com.glodblock.github.extendedae.common.tileentities.TileCrystalAssembler;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public class ContainerCrystalAssembler
extends UpgradeableMenu<TileCrystalAssembler>
implements IProgressProvider {
    @GuiSync(value=3)
    public int processingTime = -1;
    @GuiSync(value=8)
    public YesNo autoExport = YesNo.NO;
    private final AppEngSlot tank;
    public static final MenuType<ContainerCrystalAssembler> TYPE = MenuTypeBuilder.create(ContainerCrystalAssembler::new, TileCrystalAssembler.class).build("crystal_assembler");

    public ContainerCrystalAssembler(int id, Inventory ip, TileCrystalAssembler host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
        for (int x = 0; x < 9; ++x) {
            this.addSlot((Slot)new AppEngSlot((InternalInventory)host.getInput(), x), SlotSemantics.MACHINE_INPUT);
        }
        this.tank = new AppEngSlot((InternalInventory)new ConfigMenuInventory(host.getTank()), 0);
        this.addSlot((Slot)this.tank, SlotSemantics.STORAGE);
        this.addSlot((Slot)new OutputSlot((InternalInventory)host.getOutput(), 0, null), SlotSemantics.MACHINE_OUTPUT);
        this.tank.setEmptyTooltip(() -> List.of(Component.translatable((String)"gui.extendedae.crystal_assembler.tank_empty"), Component.translatable((String)"gui.extendedae.crystal_assembler.amount", (Object[])new Object[]{0, 16000}).withStyle(Tooltips.NORMAL_TOOLTIP_TEXT)));
    }

    public boolean isTank(Slot slot) {
        return slot == this.tank;
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.autoExport = (YesNo)((TileCrystalAssembler)this.getHost()).getConfigManager().getSetting(Settings.AUTO_EXPORT);
    }

    protected void standardDetectAndSendChanges() {
        if (this.isServerSide()) {
            this.processingTime = ((TileCrystalAssembler)this.getHost()).getProgress();
        }
        super.standardDetectAndSendChanges();
    }

    public int getCurrentProgress() {
        return this.processingTime;
    }

    public int getMaxProgress() {
        return 200;
    }

    public YesNo getAutoExport() {
        return this.autoExport;
    }
}

