/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.common.parts.PartModStorageBus;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.SEAEGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.glodium.network.packet.sync.Paras;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerModStorageBus
extends UpgradeableMenu<PartModStorageBus>
implements IActionHolder {
    private final Map<String, Consumer<Paras>> actions = this.createHolder();
    private static final String ACTION_PARTITION = "partition";
    public static final MenuType<ContainerModStorageBus> TYPE = MenuTypeBuilder.create(ContainerModStorageBus::new, PartModStorageBus.class).build("mod_storage_bus");
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTRACTABLE_ONLY;
    @GuiSync(value=7)
    public YesNo filterOnExtract = YesNo.YES;
    @GuiSync(value=8)
    @Nullable
    public Component connectedTo;
    @GuiSync(value=9)
    public String exp = "";

    public ContainerModStorageBus(int id, Inventory ip, PartModStorageBus te) {
        super(TYPE, id, ip, (IUpgradeableObject)te);
        this.registerClientAction(ACTION_PARTITION, this::partition);
        this.actions.put("set", o -> this.setExp((String)o.get(0)));
        this.actions.put("update", o -> {
            Player patt2221$temp = this.getPlayer();
            if (patt2221$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt2221$temp;
                EAENetworkHandler.INSTANCE.sendTo((IMessage)new SEAEGenericPacket("init", this.exp), sp);
            }
        });
        this.connectedTo = te.getConnectedToDescription();
    }

    protected void setupConfig() {
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.connectedTo = ((PartModStorageBus)this.getHost()).getConnectedToDescription();
        if (!this.exp.equals(((PartModStorageBus)this.getHost()).getModNameFilter())) {
            this.exp = ((PartModStorageBus)this.getHost()).getModNameFilter();
        }
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setReadWriteMode((AccessRestriction)cm.getSetting(Settings.ACCESS));
        this.setStorageFilter((StorageFilter)cm.getSetting(Settings.STORAGE_FILTER));
        this.setFilterOnExtract((YesNo)cm.getSetting(Settings.FILTER_ON_EXTRACT));
    }

    public boolean isSlotEnabled(int idx) {
        return false;
    }

    public void partition() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_PARTITION);
            return;
        }
        this.broadcastChanges();
    }

    public void setExp(String exp) {
        ((PartModStorageBus)this.getHost()).setModNameFilter(exp);
        this.broadcastChanges();
    }

    public AccessRestriction getReadWriteMode() {
        return this.rwMode;
    }

    private void setReadWriteMode(AccessRestriction rwMode) {
        this.rwMode = rwMode;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    private void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }

    public YesNo getFilterOnExtract() {
        return this.filterOnExtract;
    }

    public void setFilterOnExtract(YesNo filterOnExtract) {
        this.filterOnExtract = filterOnExtract;
    }

    @Nullable
    public Component getConnectedTo() {
        return this.connectedTo;
    }

    @NotNull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.actions;
    }
}

