/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.items.misc.WrappedGenericStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerPattern
extends AbstractContainerMenu {
    protected final ItemStack stack;
    protected final IPatternDetails details;
    protected final List<GenericStack[]> inputs = new ArrayList<GenericStack[]>();
    protected final List<GenericStack[]> outputs = new ArrayList<GenericStack[]>();
    private boolean valid = true;
    private int cycle = 0;

    public ContainerPattern(@Nullable MenuType<?> menuType, Level world, int id, ItemStack stack) {
        super(menuType, id);
        this.stack = stack;
        Item item = this.stack.getItem();
        if (!(item instanceof EncodedPatternItem)) {
            throw new IllegalArgumentException(String.format("%s isn't an encoded pattern!", item));
        }
        EncodedPatternItem pattern = (EncodedPatternItem)item;
        this.details = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)world, (boolean)true);
        this.analyse();
    }

    protected abstract void analyse();

    public void invalidate() {
        this.valid = false;
    }

    public void setCycleItem(int index) {
        this.cycle = index;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int idx) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.details != null && this.valid;
    }

    protected GenericStack[] clean(GenericStack[] in) {
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        set.addAll(Arrays.asList(in));
        GenericStack[] c = new GenericStack[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            GenericStack tmp;
            c[i] = tmp = (GenericStack)iterator.next();
            ++i;
        }
        return c;
    }

    public static class DisplayOnlySlot
    extends Slot {
        private static final Container EMPTY_INVENTORY = new SimpleContainer(0);
        private final ItemStack[] displays;
        private final int index;
        private final ContainerPattern container;
        private long size = 0L;

        public DisplayOnlySlot(ContainerPattern container, List<GenericStack[]> stacks, int index, int x, int y) {
            super(EMPTY_INVENTORY, 0, x, y);
            if (index >= stacks.size()) {
                this.displays = new ItemStack[0];
            } else {
                GenericStack[] genStack = stacks.get(index);
                this.displays = new ItemStack[genStack.length];
                if (genStack.length > 0) {
                    for (int i = 0; i < genStack.length; ++i) {
                        this.displays[i] = this.getAsItem(genStack[i]);
                    }
                }
            }
            this.index = index;
            this.container = container;
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return false;
        }

        public boolean mayPickup(@NotNull Player player) {
            return false;
        }

        @NotNull
        public ItemStack getItem() {
            return this.getItem(this.container.cycle);
        }

        public void set(@NotNull ItemStack stack) {
        }

        @NotNull
        public ItemStack getItem(int rowIndex) {
            if (this.displays.length > 0) {
                return this.displays[rowIndex %= this.displays.length];
            }
            return ItemStack.EMPTY;
        }

        public long getActualAmount() {
            return this.size;
        }

        public boolean shouldUseMEText() {
            return !(this.getItem().getItem() instanceof WrappedGenericStack);
        }

        public int getSlotIndex() {
            return this.index;
        }

        @NotNull
        private ItemStack getAsItem(GenericStack stack) {
            AEKey aEKey;
            if (stack != null && (aEKey = stack.what()) instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)aEKey;
                this.size = stack.amount();
                return itemKey.toStack();
            }
            return GenericStack.wrapInItemStack((GenericStack)stack);
        }
    }
}

