/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.datagen;

import com.glodblock.github.extendedae.api.ISpecialDrop;
import com.glodblock.github.extendedae.common.EAEItemAndBlock;
import com.glodblock.github.extendedae.common.EAERegistryHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class EAELootTableProvider
extends LootTableProvider {
    public EAELootTableProvider(PackOutput p) {
        super(p, Collections.emptySet(), Collections.singletonList(new LootTableProvider.SubProviderEntry(SubProvider::new, LootContextParamSets.BLOCK)));
    }

    public static class SubProvider
    extends BlockLootSubProvider {
        protected SubProvider() {
            super(Collections.emptySet(), FeatureFlagSet.of(), new HashMap());
        }

        protected void generate() {
            for (Block block : EAERegistryHandler.INSTANCE.getBlocks()) {
                if (block instanceof ISpecialDrop) continue;
                this.add(block, this.createSingleItemTable((ItemLike)block));
            }
            this.add((Block)EAEItemAndBlock.ENTRO_BUD_SMALL, this.createSingleItemTableWithSilkTouch((Block)EAEItemAndBlock.ENTRO_BUD_SMALL, (ItemLike)Items.AIR));
            this.add((Block)EAEItemAndBlock.ENTRO_BUD_MEDIUM, this.createSingleItemTableWithSilkTouch((Block)EAEItemAndBlock.ENTRO_BUD_MEDIUM, (ItemLike)Items.AIR));
            this.add((Block)EAEItemAndBlock.ENTRO_BUD_LARGE, this.createSingleItemTableWithSilkTouch((Block)EAEItemAndBlock.ENTRO_BUD_LARGE, (ItemLike)Items.AIR));
            this.add((Block)EAEItemAndBlock.ENTRO_CLUSTER, SubProvider.createSilkTouchDispatchTable((Block)EAEItemAndBlock.ENTRO_CLUSTER, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EAEItemAndBlock.ENTRO_CRYSTAL).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE)).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay())));
            this.add((Block)EAEItemAndBlock.FULLY_ENTROIZED_FLUIX_BUDDING, this.createSingleItemTable((ItemLike)EAEItemAndBlock.ENTRO_DUST));
            this.add((Block)EAEItemAndBlock.MOSTLY_ENTROIZED_FLUIX_BUDDING, this.createSingleItemTable((ItemLike)EAEItemAndBlock.ENTRO_DUST));
            this.add((Block)EAEItemAndBlock.HALF_ENTROIZED_FLUIX_BUDDING, this.createSingleItemTable((ItemLike)EAEItemAndBlock.ENTRO_DUST));
            this.add((Block)EAEItemAndBlock.HARDLY_ENTROIZED_FLUIX_BUDDING, this.createSingleItemTable((ItemLike)EAEItemAndBlock.ENTRO_DUST));
        }

        public void generate(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> bi) {
            this.generate();
            for (Map.Entry e : this.map.entrySet()) {
                bi.accept((ResourceLocation)e.getKey(), (LootTable.Builder)e.getValue());
            }
        }
    }
}

