/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.network.packet;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.AESmithingTablePattern;
import appeng.crafting.pattern.AEStonecuttingPattern;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.container.pattern.ContainerCraftingPattern;
import com.glodblock.github.extendedae.container.pattern.ContainerProcessingPattern;
import com.glodblock.github.extendedae.container.pattern.ContainerSmithingTablePattern;
import com.glodblock.github.extendedae.container.pattern.ContainerStonecuttingPattern;
import com.glodblock.github.extendedae.container.pattern.PatternGuiHandler;
import com.glodblock.github.glodium.network.packet.IMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CPatternKey
implements IMessage {
    private ItemStack pattern;
    private static long nextWarning = -1L;

    public CPatternKey() {
    }

    public CPatternKey(ItemStack stack) {
        this.pattern = stack;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeItem(this.pattern);
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.pattern = buf.readItem();
    }

    public void onMessage(Player player) {
        IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)this.pattern, (Level)player.level());
        if (details instanceof AEProcessingPattern) {
            PatternGuiHandler.open(player, ContainerProcessingPattern.ID, this.pattern);
        } else if (details instanceof AECraftingPattern) {
            PatternGuiHandler.open(player, ContainerCraftingPattern.ID, this.pattern);
        } else if (details instanceof AEStonecuttingPattern) {
            PatternGuiHandler.open(player, ContainerStonecuttingPattern.ID, this.pattern);
        } else if (details instanceof AESmithingTablePattern) {
            PatternGuiHandler.open(player, ContainerSmithingTablePattern.ID, this.pattern);
        } else if (nextWarning < System.currentTimeMillis()) {
            nextWarning = System.currentTimeMillis() + 2000L;
            player.sendSystemMessage((Component)Component.translatable((String)"chat.pattern_view.error", (Object[])new Object[]{"https://github.com/GlodBlock/ExtendedAE/issues"}));
        }
    }

    public boolean isClient() {
        return false;
    }

    @NotNull
    public ResourceLocation id() {
        return ExtendedAE.id("c_pattern_key");
    }
}

