/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.network.packet;

import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.client.gui.GuiExPatternTerminal;
import com.glodblock.github.glodium.network.packet.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SExPatternInfo
implements IMessage {
    private long id;
    private BlockPos pos;
    private ResourceKey<Level> dim;
    @Nullable
    private Direction face;

    public SExPatternInfo() {
    }

    public SExPatternInfo(long id, BlockPos pos, ResourceKey<Level> dim, @Nullable Direction face) {
        this.id = id;
        this.pos = pos;
        this.dim = dim;
        this.face = face;
    }

    public SExPatternInfo(long id, BlockPos pos, ResourceKey<Level> dim) {
        this(id, pos, dim, null);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeVarLong(this.id);
        buf.writeVarLong(this.pos.asLong());
        buf.writeResourceKey(this.dim);
        if (this.face == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeEnum((Enum)this.face);
        }
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.id = buf.readVarLong();
        this.pos = BlockPos.of((long)buf.readVarLong());
        this.dim = buf.readResourceKey(Registries.DIMENSION);
        if (buf.readBoolean()) {
            this.face = (Direction)buf.readEnum(Direction.class);
        }
    }

    public void onMessage(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof GuiExPatternTerminal) {
            GuiExPatternTerminal gui = (GuiExPatternTerminal)screen;
            gui.postTileInfo(this.id, this.pos, this.dim, this.face);
        }
    }

    public boolean isClient() {
        return true;
    }

    @NotNull
    public ResourceLocation id() {
        return ExtendedAE.id("s_ex_pattern_info");
    }
}

