/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.recipe;

import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.recipe.CrystalAssemblerRecipeSerializer;
import com.glodblock.github.extendedae.recipe.util.IngredientStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrystalAssemblerRecipe
implements Recipe<Container> {
    public static final ResourceLocation ID = ExtendedAE.id("crystal_assembler");
    public static final RecipeType<CrystalAssemblerRecipe> TYPE = RecipeType.simple((ResourceLocation)ID);
    protected final List<IngredientStack.Item> inputs;
    protected final Optional<IngredientStack.Fluid> fluid;
    public final ItemStack output;

    public CrystalAssemblerRecipe(ItemStack output, List<IngredientStack.Item> inputs, IngredientStack.Fluid fluid) {
        this(output, inputs, Optional.ofNullable(fluid));
    }

    public CrystalAssemblerRecipe(ItemStack output, List<IngredientStack.Item> inputs, Optional<IngredientStack.Fluid> fluid) {
        this.output = output;
        this.inputs = inputs;
        this.fluid = fluid;
    }

    public List<IngredientStack.Item> getInputs() {
        return this.inputs;
    }

    @Nullable
    public IngredientStack.Fluid getFluid() {
        return this.fluid.orElse(null);
    }

    public List<IngredientStack<?>> getSample() {
        ArrayList sample = new ArrayList();
        for (IngredientStack.Item in : this.inputs) {
            if (in.isEmpty()) continue;
            sample.add(in.sample());
        }
        this.fluid.ifPresent(ingredientStack -> sample.add(ingredientStack.sample()));
        return sample;
    }

    public boolean matches(@NotNull Container pContainer, @NotNull Level pLevel) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull Container pContainer, @NotNull RegistryAccess pRegistryAccess) {
        return this.getResultItem(pRegistryAccess).copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull RegistryAccess pRegistryAccess) {
        return this.output;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return CrystalAssemblerRecipeSerializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return TYPE;
    }

    public boolean isSpecial() {
        return true;
    }
}

