/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.recipe;

import com.glodblock.github.extendedae.recipe.CrystalAssemblerRecipe;
import com.glodblock.github.extendedae.recipe.util.IngredientStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class CrystalAssemblerRecipeSerializer
implements RecipeSerializer<CrystalAssemblerRecipe> {
    public static final CrystalAssemblerRecipeSerializer INSTANCE = new CrystalAssemblerRecipeSerializer();
    public static final Codec<CrystalAssemblerRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("output").forGetter(ir -> ir.output), (App)IngredientStack.ITEM_CODEC.listOf().fieldOf("input_items").forGetter(ir -> ir.inputs), (App)IngredientStack.FLUID_CODEC.optionalFieldOf("input_fluid").forGetter(ir -> ir.fluid)).apply((Applicative)builder, CrystalAssemblerRecipe::new));

    private CrystalAssemblerRecipeSerializer() {
    }

    @NotNull
    public Codec<CrystalAssemblerRecipe> codec() {
        return CODEC;
    }

    @NotNull
    public CrystalAssemblerRecipe fromNetwork(@NotNull FriendlyByteBuf buffer) {
        ItemStack output = buffer.readItem();
        int inputSize = buffer.readByte();
        ArrayList<IngredientStack.Item> inputs = new ArrayList<IngredientStack.Item>();
        for (int i = 0; i < inputSize; ++i) {
            inputs.add(IngredientStack.ofItem(buffer));
        }
        IngredientStack.Fluid fluid = null;
        if (buffer.readBoolean()) {
            fluid = IngredientStack.ofFluid(buffer);
        }
        return new CrystalAssemblerRecipe(output, inputs, fluid);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull CrystalAssemblerRecipe recipe) {
        buffer.writeItem(recipe.output);
        buffer.writeByte(recipe.inputs.size());
        for (IngredientStack.Item is : recipe.inputs) {
            is.to(buffer);
        }
        buffer.writeBoolean(recipe.fluid.isPresent());
        recipe.fluid.ifPresent(f -> f.to(buffer));
    }
}

