/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.recipe.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidIngredient
implements Predicate<FluidStack> {
    private final List<Fluid> fluids = new ArrayList<Fluid>();
    protected final Value value;
    private static final Codec<Value> CODEC_VALUE = ExtraCodecs.xor(FluidValue.CODEC, TagValue.CODEC).xmap(e -> (Value)e.map(a -> a, b -> b), v -> {
        if (v instanceof FluidValue) {
            FluidValue f = (FluidValue)v;
            return Either.left((Object)f);
        }
        if (v instanceof TagValue) {
            TagValue f = (TagValue)v;
            return Either.right((Object)f);
        }
        throw new IllegalArgumentException();
    });
    public static final Codec<FluidIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CODEC_VALUE.fieldOf("fluid_ingredient").forGetter(fi -> fi.value)).apply((Applicative)builder, FluidIngredient::new));

    public List<Fluid> getFluid() {
        return this.fluids;
    }

    public static FluidIngredient of(FriendlyByteBuf buff) {
        byte type = buff.readByte();
        if (type == 0) {
            return new FluidIngredient(new FluidValue(buff.readFluidStack()));
        }
        if (type == 1) {
            return new FluidIngredient(new TagValue((TagKey<Fluid>)TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)buff.readResourceLocation())));
        }
        throw new IllegalArgumentException();
    }

    public void to(FriendlyByteBuf buff) {
        Value value = this.value;
        if (value instanceof FluidValue) {
            FluidValue f = (FluidValue)value;
            buff.writeByte(0);
            buff.writeFluidStack(f.fluid);
        } else {
            value = this.value;
            if (value instanceof TagValue) {
                TagValue f = (TagValue)value;
                buff.writeByte(1);
                buff.writeResourceLocation(f.fluid.location());
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    public FluidIngredient(Value v) {
        this.value = v;
        if (v instanceof FluidValue) {
            FluidValue fluid = (FluidValue)v;
            if (!fluid.fluid.isEmpty()) {
                this.fluids.add(fluid.fluid.getFluid());
            }
        } else if (v instanceof TagValue) {
            TagValue fluid = (TagValue)v;
            for (Holder holder : BuiltInRegistries.FLUID.getTagOrEmpty(fluid.fluid)) {
                this.fluids.add((Fluid)holder.value());
            }
        }
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        if (this.fluids.isEmpty()) {
            return fluidStack.isEmpty();
        }
        if (fluidStack.isEmpty()) {
            return false;
        }
        Fluid fluid = fluidStack.getFluid();
        for (Fluid tf : this.fluids) {
            if (!tf.isSame(fluid)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        Value value = this.value;
        if (value instanceof TagValue) {
            TagValue f = (TagValue)value;
            return "tag: " + f.fluid;
        }
        value = this.value;
        if (value instanceof FluidValue) {
            FluidValue f = (FluidValue)value;
            return "fluid: " + f.fluid;
        }
        return super.toString();
    }

    public record FluidValue(FluidStack fluid) implements Value
    {
        public static final Codec<FluidValue> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(FluidValue::fluid)).apply((Applicative)builder, FluidValue::new));
    }

    public static interface Value {
    }

    public record TagValue(TagKey<Fluid> fluid) implements Value
    {
        public static final Codec<TagValue> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("tag").forGetter(TagValue::fluid)).apply((Applicative)builder, TagValue::new));
    }
}

