/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.recipe.util;

import com.glodblock.github.extendedae.recipe.util.FluidIngredient;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class IngredientStack<T> {
    protected final Predicate<T> ingredient;
    protected int amount;
    public static final Codec<Item> ITEM_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(i -> (Ingredient)i.ingredient), (App)ExtraCodecs.strictOptionalField((Codec)ExtraCodecs.POSITIVE_INT, (String)"amount", (Object)1).forGetter(i -> i.amount)).apply((Applicative)builder, Item::new));
    public static final Codec<Fluid> FLUID_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)FluidIngredient.CODEC.fieldOf("ingredient").forGetter(i -> (FluidIngredient)i.ingredient), (App)ExtraCodecs.strictOptionalField((Codec)ExtraCodecs.POSITIVE_INT, (String)"amount", (Object)1).forGetter(i -> i.amount)).apply((Applicative)builder, Fluid::new));

    public IngredientStack(Predicate<T> ingredient, int amount) {
        this.ingredient = ingredient;
        this.amount = amount;
    }

    public Predicate<T> getIngredient() {
        return this.ingredient;
    }

    public int getAmount() {
        return this.amount;
    }

    public static Item of(ItemStack ingredient) {
        return new Item(Ingredient.of((ItemStack[])new ItemStack[]{ingredient}), ingredient.getCount());
    }

    public static Item of(Ingredient ingredient, int amount) {
        return new Item(ingredient, amount);
    }

    public static Fluid of(FluidStack ingredient) {
        return new Fluid(new FluidIngredient(new FluidIngredient.FluidValue(ingredient)), ingredient.getAmount());
    }

    public static Fluid of(FluidIngredient ingredient, int amount) {
        return new Fluid(ingredient, amount);
    }

    public static Item ofItem(FriendlyByteBuf buff) {
        return new Item(Ingredient.fromNetwork((FriendlyByteBuf)buff), buff.readInt());
    }

    public static Fluid ofFluid(FriendlyByteBuf buff) {
        return new Fluid(FluidIngredient.of(buff), buff.readInt());
    }

    public abstract void to(FriendlyByteBuf var1);

    public void consume(Object stack) {
        if (this.amount <= 0) {
            return;
        }
        if (this.ingredient.test(stack)) {
            int from = this.getStackAmount(stack);
            if (from > this.amount) {
                this.setStackAmount(stack, from - this.amount);
                this.amount = 0;
            } else {
                this.setStackAmount(stack, 0);
                this.amount -= from;
            }
        }
    }

    public boolean isEmpty() {
        return this.amount <= 0;
    }

    public abstract boolean checkType(Object var1);

    public abstract IngredientStack<T> sample();

    public abstract int getStackAmount(T var1);

    public abstract void setStackAmount(T var1, int var2);

    public String toString() {
        return this.amount + " " + this.ingredient;
    }

    public static final class Item
    extends IngredientStack<ItemStack> {
        public static final Item EMPTY = new Item(Ingredient.EMPTY, 0);

        private Item(Ingredient ingredient, int amount) {
            super(ingredient, amount);
        }

        @Override
        public void to(FriendlyByteBuf buff) {
            ((Ingredient)this.ingredient).toNetwork(buff);
            buff.writeInt(this.amount);
        }

        @Override
        public boolean checkType(Object obj) {
            return obj instanceof ItemStack;
        }

        public Item sample() {
            return new Item((Ingredient)this.ingredient, this.amount);
        }

        @Override
        public int getStackAmount(ItemStack stack) {
            return stack.getCount();
        }

        @Override
        public void setStackAmount(ItemStack stack, int amount) {
            stack.setCount(amount);
        }
    }

    public static final class Fluid
    extends IngredientStack<FluidStack> {
        public static final Fluid EMPTY = new Fluid(new FluidIngredient(new FluidIngredient.FluidValue(FluidStack.EMPTY)), 0);

        private Fluid(FluidIngredient ingredient, int amount) {
            super(ingredient, amount);
        }

        @Override
        public void to(FriendlyByteBuf buff) {
            ((FluidIngredient)this.ingredient).to(buff);
            buff.writeInt(this.amount);
        }

        @Override
        public boolean checkType(Object obj) {
            return obj instanceof FluidStack;
        }

        @Override
        public IngredientStack<FluidStack> sample() {
            return new Fluid((FluidIngredient)this.ingredient, this.amount);
        }

        @Override
        public int getStackAmount(FluidStack stack) {
            return stack.getAmount();
        }

        @Override
        public void setStackAmount(FluidStack stack, int amount) {
            stack.setAmount(amount);
        }
    }
}

