/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.util;

import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.parts.IPart;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.networking.CableBusBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FCUtil {
    public static void replaceTile(Level world, BlockPos pos, BlockEntity oldTile, BlockEntity newTile, BlockState newBlock) {
        CompoundTag contents = oldTile.serializeNBT();
        world.removeBlockEntity(pos);
        world.removeBlock(pos, false);
        world.setBlock(pos, newBlock, 3);
        world.setBlockEntity(newTile);
        newTile.deserializeNBT(contents);
        if (newTile instanceof AEBaseBlockEntity) {
            AEBaseBlockEntity aeTile = (AEBaseBlockEntity)newTile;
            aeTile.markForUpdate();
        } else {
            newTile.setChanged();
        }
    }

    public static IPart getPart(BlockEntity te, Direction face) {
        if (te instanceof CableBusBlockEntity) {
            CableBusBlockEntity cable = (CableBusBlockEntity)te;
            return cable.getPart(face);
        }
        return null;
    }

    public static boolean checkInvalidRL(String rl, Registry<?> registry) {
        return FCUtil.checkInvalidRL(new ResourceLocation(rl), registry);
    }

    public static boolean checkInvalidRL(ResourceLocation rl, Registry<?> registry) {
        return registry.containsKey(rl);
    }

    public static boolean ejectInv(Level world, BlockPos pos, InternalInventory inv) {
        for (Direction dir : Direction.values()) {
            ItemTransfer target = InternalInventory.wrapExternal((Level)world, (BlockPos)pos.relative(dir), (Direction)dir.getOpposite());
            if (target == null) continue;
            int startItems = inv.getStackInSlot(0).getCount();
            inv.insertItem(0, target.addItems(inv.extractItem(0, 64, false)), false);
            int endItems = inv.getStackInSlot(0).getCount();
            if (startItems == endItems) continue;
            return true;
        }
        return false;
    }

    public static int speedCardMap(int card) {
        return FCUtil.speedCardMap(card, 1);
    }

    public static int speedCardMap(int card, int multi) {
        return multi * (switch (card) {
            default -> 2;
            case 1 -> 3;
            case 2 -> 5;
            case 3 -> 10;
            case 4 -> 50;
        });
    }
}

