/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.util.recipe;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeSearchContext<C extends Container, T extends Recipe<C>> {
    public boolean stuck;
    public boolean dirty;
    @Nullable
    public RecipeHolder<T> lastRecipe;
    @Nullable
    public RecipeHolder<T> currentRecipe;
    private final Supplier<Level> levelGetter;
    private final RecipeType<T> type;

    public RecipeSearchContext(Supplier<Level> levelGetter, RecipeType<T> type) {
        this.levelGetter = levelGetter;
        this.type = type;
    }

    public void findRecipe() {
        if (this.lastRecipe != null) {
            if (this.testRecipe(this.lastRecipe)) {
                this.currentRecipe = this.lastRecipe;
                this.stuck = false;
                return;
            }
            this.lastRecipe = null;
        }
        this.stuck = false;
        this.onFind(this.searchRecipe());
    }

    public void onInvChange() {
        this.stuck = false;
        this.dirty = true;
    }

    public boolean shouldTick() {
        if (this.currentRecipe != null) {
            return true;
        }
        return !this.stuck;
    }

    public void onFind(@Nullable RecipeHolder<T> recipe) {
        if (recipe == null) {
            if (this.dirty) {
                this.dirty = false;
                return;
            }
            this.stuck = true;
            this.currentRecipe = null;
            return;
        }
        this.dirty = false;
        this.lastRecipe = recipe;
        this.currentRecipe = recipe;
        this.stuck = false;
    }

    public RecipeHolder<T> searchRecipe() {
        Level level = this.levelGetter.get();
        if (level == null) {
            return null;
        }
        Map recipes = level.getRecipeManager().byType(this.type);
        for (RecipeHolder recipe : recipes.values()) {
            if (!this.testRecipe(recipe)) continue;
            return recipe;
        }
        return null;
    }

    public abstract boolean testRecipe(RecipeHolder<T> var1);

    public abstract void runRecipe(RecipeHolder<T> var1);

    public void save(CompoundTag tag) {
        CompoundTag nbt = new CompoundTag();
        if (this.currentRecipe != null) {
            nbt.putString("current", this.currentRecipe.id().toString());
        }
        if (this.lastRecipe != null) {
            nbt.putString("last", this.lastRecipe.id().toString());
        }
        tag.put("recipeCtx", (Tag)nbt);
    }

    public void load(CompoundTag tag) {
        ResourceLocation id;
        Level level = this.levelGetter.get();
        if (level == null) {
            return;
        }
        CompoundTag nbt = tag.getCompound("recipeCtx");
        if (nbt.contains("current")) {
            try {
                id = new ResourceLocation(tag.getString("current"));
                this.currentRecipe = (RecipeHolder)level.getRecipeManager().byType(this.type).get(id);
            }
            catch (Throwable e) {
                this.currentRecipe = null;
            }
        }
        if (nbt.contains("last")) {
            try {
                id = new ResourceLocation(tag.getString("last"));
                this.lastRecipe = (RecipeHolder)level.getRecipeManager().byType(this.type).get(id);
            }
            catch (Throwable e) {
                this.lastRecipe = null;
            }
        }
    }
}

