/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.xmod.emi;

import com.glodblock.github.extendedae.common.EAEItemAndBlock;
import com.glodblock.github.extendedae.recipe.CircuitCutterRecipe;
import com.glodblock.github.extendedae.recipe.CrystalAssemblerRecipe;
import com.glodblock.github.extendedae.util.Ae2ReflectClient;
import com.glodblock.github.extendedae.xmod.emi.PatternSlotProvider;
import com.glodblock.github.extendedae.xmod.emi.recipes.EMICircuitCutterRecipe;
import com.glodblock.github.extendedae.xmod.emi.recipes.EMICrystalAssemblerRecipe;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class EMIPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.addGenericStackProvider((EmiStackProvider)new PatternSlotProvider());
        registry.addWorkstation(Ae2ReflectClient.getInscribeRecipe(), (EmiIngredient)EmiStack.of((ItemLike)EAEItemAndBlock.EX_INSCRIBER));
        registry.addWorkstation(Ae2ReflectClient.getChargerRecipe(), (EmiIngredient)EmiStack.of((ItemLike)EAEItemAndBlock.EX_CHARGER));
        registry.setDefaultComparison((Object)EAEItemAndBlock.INFINITY_CELL, Comparison.compareData(s -> EAEItemAndBlock.INFINITY_CELL.getRecord(s.getItemStack())));
        registry.addCategory(EMICrystalAssemblerRecipe.CATEGORY);
        registry.addWorkstation(EMICrystalAssemblerRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)EAEItemAndBlock.CRYSTAL_ASSEMBLER));
        EMIPlugin.adaptRecipeType(registry, CrystalAssemblerRecipe.TYPE, EMICrystalAssemblerRecipe::new);
        registry.addCategory(EMICircuitCutterRecipe.CATEGORY);
        registry.addWorkstation(EMICircuitCutterRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)EAEItemAndBlock.CIRCUIT_CUTTER));
        EMIPlugin.adaptRecipeType(registry, CircuitCutterRecipe.TYPE, EMICircuitCutterRecipe::new);
        EMIPlugin.addInfo(registry, (ItemLike)EAEItemAndBlock.ENTRO_CRYSTAL, new Component[]{Component.translatable((String)"emi.extendedae.desc.entro_crystal")});
        EMIPlugin.addInfo(registry, (ItemLike)EAEItemAndBlock.ENTRO_SEED, new Component[]{Component.translatable((String)"emi.extendedae.desc.entro_seed")});
    }

    private static <C extends Container, T extends Recipe<C>> void adaptRecipeType(EmiRegistry registry, RecipeType<T> recipeType, Function<RecipeHolder<T>, ? extends EmiRecipe> adapter) {
        registry.getRecipeManager().getAllRecipesFor(recipeType).stream().map(adapter).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }

    private static void addInfo(EmiRegistry registry, ItemLike item, Component ... desc) {
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((ItemLike)item)), Arrays.stream(desc).toList(), null));
    }
}

