/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.options.control;

import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.Validate;

public class SliderControl
implements Control<Integer> {
    private final Option<Integer> option;
    private final int min;
    private final int max;
    private final int interval;
    private final ControlValueFormatter mode;

    public SliderControl(Option<Integer> option, int min, int max, int interval, ControlValueFormatter mode) {
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"The maximum value must be greater than the minimum value", (Object[])new Object[0]);
        Validate.isTrue((interval > 0 ? 1 : 0) != 0, (String)"The slider interval must be greater than zero", (Object[])new Object[0]);
        Validate.isTrue(((max - min) % interval == 0 ? 1 : 0) != 0, (String)"The maximum value must be divisable by the interval", (Object[])new Object[0]);
        Validate.notNull((Object)mode, (String)"The slider mode must not be null", (Object[])new Object[0]);
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.mode = mode;
    }

    @Override
    public ControlElement<Integer> createElement(Dim2i dim) {
        return new Button(this.option, dim, this.min, this.max, this.interval, this.mode);
    }

    @Override
    public Option<Integer> getOption() {
        return this.option;
    }

    @Override
    public int getMaxWidth() {
        return 130;
    }

    private static class Button
    extends ControlElement<Integer> {
        private static final int THUMB_WIDTH = 2;
        private static final int TRACK_HEIGHT = 1;
        private final Rect2i sliderBounds;
        private final ControlValueFormatter formatter;
        private final int min;
        private final int max;
        private final int range;
        private final int interval;
        private double thumbPosition;
        private boolean sliderHeld;

        public Button(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter) {
            super(option, dim);
            this.min = min;
            this.max = max;
            this.range = max - min;
            this.interval = interval;
            this.thumbPosition = this.getThumbPositionForValue(option.getValue());
            this.formatter = formatter;
            this.sliderBounds = new Rect2i(dim.getLimitX() - 96, dim.getCenterY() - 5, 90, 10);
            this.sliderHeld = false;
        }

        @Override
        public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            super.render(drawContext, mouseX, mouseY, delta);
            if (this.option.isAvailable() && (this.hovered || this.isFocused())) {
                this.renderSlider(drawContext);
            } else {
                this.renderStandaloneValue(drawContext);
            }
        }

        private void renderStandaloneValue(GuiGraphics drawContext) {
            int sliderX = this.sliderBounds.getX();
            int sliderY = this.sliderBounds.getY();
            int sliderWidth = this.sliderBounds.getWidth();
            int sliderHeight = this.sliderBounds.getHeight();
            Component label = this.formatter.format((Integer)this.option.getValue());
            int labelWidth = this.font.width((FormattedText)label);
            this.drawString(drawContext, label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 - 4, -1);
        }

        private void renderSlider(GuiGraphics drawContext) {
            int sliderX = this.sliderBounds.getX();
            int sliderY = this.sliderBounds.getY();
            int sliderWidth = this.sliderBounds.getWidth();
            int sliderHeight = this.sliderBounds.getHeight();
            this.thumbPosition = this.getThumbPositionForValue((Integer)this.option.getValue());
            double thumbOffset = Mth.clamp((double)((double)(this.getIntValue() - this.min) / (double)this.range * (double)sliderWidth), (double)0.0, (double)sliderWidth);
            int thumbX = (int)((double)sliderX + thumbOffset - 2.0);
            int trackY = (int)((double)((float)sliderY + (float)sliderHeight / 2.0f) - 0.5);
            this.drawRect(drawContext, thumbX, sliderY, thumbX + 4, sliderY + sliderHeight, -1);
            this.drawRect(drawContext, sliderX, trackY, sliderX + sliderWidth, trackY + 1, -1);
            String label = this.formatter.format(this.getIntValue()).getString();
            int labelWidth = this.font.width(label);
            this.drawString(drawContext, label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 - 4, -1);
        }

        public int getIntValue() {
            return this.min + this.interval * (int)Math.round(this.getSnappedThumbPosition() / (double)this.interval);
        }

        public double getSnappedThumbPosition() {
            return this.thumbPosition / (1.0 / (double)this.range);
        }

        public double getThumbPositionForValue(int value) {
            return (double)(value - this.min) * (1.0 / (double)this.range);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.sliderHeld = false;
            if (this.option.isAvailable() && button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
                if (this.sliderBounds.contains((int)mouseX, (int)mouseY)) {
                    this.setValueFromMouse(mouseX);
                    this.sliderHeld = true;
                }
                return true;
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            this.setValue((d - (double)this.sliderBounds.getX()) / (double)this.sliderBounds.getWidth());
        }

        public void setValue(double d) {
            this.thumbPosition = Mth.clamp((double)d, (double)0.0, (double)1.0);
            int value = this.getIntValue();
            if ((Integer)this.option.getValue() != value) {
                this.option.setValue(value);
            }
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (!this.isFocused()) {
                return false;
            }
            if (keyCode == 263) {
                this.option.setValue(Mth.clamp((int)((Integer)this.option.getValue() - this.interval), (int)this.min, (int)this.max));
                return true;
            }
            if (keyCode == 262) {
                this.option.setValue(Mth.clamp((int)((Integer)this.option.getValue() + this.interval), (int)this.min, (int)this.max));
                return true;
            }
            return false;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.option.isAvailable() && button == 0) {
                if (this.sliderHeld) {
                    this.setValueFromMouse(mouseX);
                }
                return true;
            }
            return false;
        }
    }
}

