/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.smooth;

import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.light.smooth.AoFaceData;
import me.jellysquid.mods.sodium.client.model.light.smooth.AoNeighborInfo;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

public class SmoothLightPipeline
implements LightPipeline {
    private final LightDataAccess lightCache;
    private final AoFaceData[] cachedFaceData = new AoFaceData[12];
    private long cachedPos = Long.MIN_VALUE;
    private final float[] weights = new float[4];

    public SmoothLightPipeline(LightDataAccess cache) {
        this.lightCache = cache;
        for (int i = 0; i < this.cachedFaceData.length; ++i) {
            this.cachedFaceData[i] = new AoFaceData();
        }
    }

    @Override
    public void calculate(ModelQuadView quad, BlockPos pos, QuadLightData out, Direction cullFace, Direction lightFace, boolean shade) {
        this.updateCachedData(pos.asLong());
        int flags = quad.getFlags();
        AoNeighborInfo neighborInfo = AoNeighborInfo.get(lightFace);
        if ((flags & 4) != 0 || (flags & 2) != 0 && LightDataAccess.unpackFC(this.lightCache.get(pos))) {
            if ((flags & 1) == 0) {
                this.applyAlignedFullFace(neighborInfo, pos, lightFace, out);
            } else {
                this.applyAlignedPartialFace(neighborInfo, quad, pos, lightFace, out);
            }
        } else if ((flags & 2) != 0) {
            this.applyParallelFace(neighborInfo, quad, pos, lightFace, out);
        } else {
            this.applyNonParallelFace(neighborInfo, quad, pos, lightFace, out);
        }
        this.applySidedBrightness(out, lightFace, shade);
    }

    @Override
    public void reset() {
        this.cachedPos = Long.MIN_VALUE;
    }

    private void applyAlignedFullFace(AoNeighborInfo neighborInfo, BlockPos pos, Direction dir, QuadLightData out) {
        AoFaceData faceData = this.getCachedFaceData(pos, dir, true);
        neighborInfo.mapCorners(faceData.lm, faceData.ao, out.lm, out.br);
    }

    private void applyAlignedPartialFace(AoNeighborInfo neighborInfo, ModelQuadView quad, BlockPos pos, Direction dir, QuadLightData out) {
        for (int i = 0; i < 4; ++i) {
            float cx = SmoothLightPipeline.clamp(quad.getX(i));
            float cy = SmoothLightPipeline.clamp(quad.getY(i));
            float cz = SmoothLightPipeline.clamp(quad.getZ(i));
            float[] weights = this.weights;
            neighborInfo.calculateCornerWeights(cx, cy, cz, weights);
            this.applyAlignedPartialFaceVertex(pos, dir, weights, i, out, true);
        }
    }

    private void applyParallelFace(AoNeighborInfo neighborInfo, ModelQuadView quad, BlockPos pos, Direction dir, QuadLightData out) {
        for (int i = 0; i < 4; ++i) {
            float cx = SmoothLightPipeline.clamp(quad.getX(i));
            float cy = SmoothLightPipeline.clamp(quad.getY(i));
            float cz = SmoothLightPipeline.clamp(quad.getZ(i));
            float[] weights = this.weights;
            neighborInfo.calculateCornerWeights(cx, cy, cz, weights);
            float depth = neighborInfo.getDepth(cx, cy, cz);
            if (Mth.equal((float)depth, (float)1.0f)) {
                this.applyAlignedPartialFaceVertex(pos, dir, weights, i, out, false);
                continue;
            }
            this.applyInsetPartialFaceVertex(pos, dir, depth, 1.0f - depth, weights, i, out);
        }
    }

    private void applyNonParallelFace(AoNeighborInfo neighborInfo, ModelQuadView quad, BlockPos pos, Direction dir, QuadLightData out) {
        for (int i = 0; i < 4; ++i) {
            float cx = SmoothLightPipeline.clamp(quad.getX(i));
            float cy = SmoothLightPipeline.clamp(quad.getY(i));
            float cz = SmoothLightPipeline.clamp(quad.getZ(i));
            float[] weights = this.weights;
            neighborInfo.calculateCornerWeights(cx, cy, cz, weights);
            float depth = neighborInfo.getDepth(cx, cy, cz);
            if (Mth.equal((float)depth, (float)0.0f)) {
                this.applyAlignedPartialFaceVertex(pos, dir, weights, i, out, true);
                continue;
            }
            if (Mth.equal((float)depth, (float)1.0f)) {
                this.applyAlignedPartialFaceVertex(pos, dir, weights, i, out, false);
                continue;
            }
            this.applyInsetPartialFaceVertex(pos, dir, depth, 1.0f - depth, weights, i, out);
        }
    }

    private void applyAlignedPartialFaceVertex(BlockPos pos, Direction dir, float[] w, int i, QuadLightData out, boolean offset) {
        float ao;
        AoFaceData faceData = this.getCachedFaceData(pos, dir, offset);
        if (!faceData.hasUnpackedLightData()) {
            faceData.unpackLightData();
        }
        float sl = faceData.getBlendedSkyLight(w);
        float bl = faceData.getBlendedBlockLight(w);
        out.br[i] = ao = faceData.getBlendedShade(w);
        out.lm[i] = SmoothLightPipeline.getLightMapCoord(sl, bl);
    }

    private void applyInsetPartialFaceVertex(BlockPos pos, Direction dir, float n1d, float n2d, float[] w, int i, QuadLightData out) {
        AoFaceData n2;
        AoFaceData n1 = this.getCachedFaceData(pos, dir, false);
        if (!n1.hasUnpackedLightData()) {
            n1.unpackLightData();
        }
        if (!(n2 = this.getCachedFaceData(pos, dir, true)).hasUnpackedLightData()) {
            n2.unpackLightData();
        }
        float ao = n1.getBlendedShade(w) * n1d + n2.getBlendedShade(w) * n2d;
        float sl = n1.getBlendedSkyLight(w) * n1d + n2.getBlendedSkyLight(w) * n2d;
        float bl = n1.getBlendedBlockLight(w) * n1d + n2.getBlendedBlockLight(w) * n2d;
        out.br[i] = ao;
        out.lm[i] = SmoothLightPipeline.getLightMapCoord(sl, bl);
    }

    private void applySidedBrightness(QuadLightData out, Direction face, boolean shade) {
        float brightness = this.lightCache.getWorld().getShade(face, shade);
        float[] br = out.br;
        int i = 0;
        while (i < br.length) {
            int n = i++;
            br[n] = br[n] * brightness;
        }
    }

    private AoFaceData getCachedFaceData(BlockPos pos, Direction face, boolean offset) {
        AoFaceData data = this.cachedFaceData[offset ? face.ordinal() : face.ordinal() + 6];
        if (!data.hasLightData()) {
            data.initLightData(this.lightCache, pos, face, offset);
        }
        return data;
    }

    private void updateCachedData(long key) {
        if (this.cachedPos != key) {
            for (AoFaceData data : this.cachedFaceData) {
                data.reset();
            }
            this.cachedPos = key;
        }
    }

    private static float clamp(float v) {
        if (v < 0.0f) {
            return 0.0f;
        }
        if (v > 1.0f) {
            return 1.0f;
        }
        return v;
    }

    private static int getLightMapCoord(float sl, float bl) {
        return ((int)sl & 0xFF) << 16 | (int)bl & 0xFF;
    }
}

