/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.platform;

import com.mojang.blaze3d.platform.Window;
import java.nio.ByteBuffer;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.compatibility.environment.OSInfo;
import me.jellysquid.mods.sodium.client.platform.windows.api.User32;
import me.jellysquid.mods.sodium.client.platform.windows.api.msgbox.MsgBoxCallback;
import me.jellysquid.mods.sodium.client.platform.windows.api.msgbox.MsgBoxParamSw;
import net.minecraft.Util;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class MessageBox {
    @Nullable
    private static final MessageBoxImpl IMPL = MessageBoxImpl.chooseImpl();

    public static void showMessageBox(@Nullable Window window, IconType icon, String title, String description, @Nullable String helpUrl) {
        if (IMPL != null) {
            IMPL.showMessageBox(window, icon, title, description, helpUrl);
        }
    }

    private static interface MessageBoxImpl {
        @Nullable
        public static MessageBoxImpl chooseImpl() {
            if (OSInfo.getOS() == OSInfo.OS.WINDOWS) {
                return new WindowsMessageBoxImpl();
            }
            return null;
        }

        public void showMessageBox(@Nullable Window var1, IconType var2, String var3, String var4, @Nullable String var5);
    }

    public static enum IconType {
        INFO,
        WARNING,
        ERROR;

    }

    private static class WindowsMessageBoxImpl
    implements MessageBoxImpl {
        private WindowsMessageBoxImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void showMessageBox(@Nullable Window window, IconType icon, String title, String description, @Nullable String helpUrl) {
            Objects.requireNonNull(title);
            Objects.requireNonNull(description);
            Objects.requireNonNull(icon);
            MsgBoxCallback msgBoxCallback = helpUrl != null ? MsgBoxCallback.create(lpHelpInfo -> Util.getPlatform().openUri(helpUrl)) : null;
            long hWndOwner = window != null ? GLFWNativeWin32.glfwGetWin32Window((long)window.getWindow()) : 0L;
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer lpText = stack.malloc(MemoryUtil.memLengthUTF16((CharSequence)description, (boolean)true));
                MemoryUtil.memUTF16((CharSequence)description, (boolean)true, (ByteBuffer)lpText);
                ByteBuffer lpCaption = stack.malloc(MemoryUtil.memLengthUTF16((CharSequence)title, (boolean)true));
                MemoryUtil.memUTF16((CharSequence)title, (boolean)true, (ByteBuffer)lpCaption);
                MsgBoxParamSw params = MsgBoxParamSw.allocate(stack);
                params.setCbSize(MsgBoxParamSw.SIZEOF);
                params.setHWndOwner(hWndOwner);
                params.setText(lpText);
                params.setCaption(lpCaption);
                params.setStyle(WindowsMessageBoxImpl.getStyle(icon, msgBoxCallback != null));
                params.setCallback(msgBoxCallback);
                User32.callMessageBoxIndirectW(params);
            }
            finally {
                if (msgBoxCallback != null) {
                    msgBoxCallback.free();
                }
            }
        }

        private static int getStyle(IconType icon, boolean showHelp) {
            int style;
            switch (icon) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INFO: {
                    int n = 64;
                    break;
                }
                case WARNING: {
                    int n = 48;
                    break;
                }
                case ERROR: {
                    int n = style = 16;
                }
            }
            if (showHelp) {
                style |= 0x4000;
            }
            return style;
        }
    }
}

