/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.viewport;

import me.jellysquid.mods.sodium.client.render.viewport.CameraTransform;
import me.jellysquid.mods.sodium.client.render.viewport.frustum.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.extensions.IBlockEntityRendererExtension;
import org.joml.Vector3d;

public final class Viewport {
    private final Frustum frustum;
    private final CameraTransform transform;
    private final SectionPos chunkCoords;
    private final BlockPos blockCoords;

    public Viewport(Frustum frustum, Vector3d position) {
        this.frustum = frustum;
        this.transform = new CameraTransform(position.x, position.y, position.z);
        this.chunkCoords = SectionPos.of((int)SectionPos.posToSectionCoord((double)position.x), (int)SectionPos.posToSectionCoord((double)position.y), (int)SectionPos.posToSectionCoord((double)position.z));
        this.blockCoords = BlockPos.containing((double)position.x, (double)position.y, (double)position.z);
    }

    public boolean isBoxVisible(AABB box) {
        if (box.equals((Object)IBlockEntityRendererExtension.INFINITE_EXTENT_AABB)) {
            return true;
        }
        return this.frustum.testAab((float)(box.minX - (double)this.transform.intX) - this.transform.fracX, (float)(box.minY - (double)this.transform.intY) - this.transform.fracY, (float)(box.minZ - (double)this.transform.intZ) - this.transform.fracZ, (float)(box.maxX - (double)this.transform.intX) - this.transform.fracX, (float)(box.maxY - (double)this.transform.intY) - this.transform.fracY, (float)(box.maxZ - (double)this.transform.intZ) - this.transform.fracZ);
    }

    public boolean isBoxVisible(int intOriginX, int intOriginY, int intOriginZ, float floatSize) {
        return this.isBoxVisible(intOriginX, intOriginY, intOriginZ, floatSize, floatSize, floatSize);
    }

    public boolean isBoxVisible(int intOriginX, int intOriginY, int intOriginZ, float floatSizeX, float floatSizeY, float floatSizeZ) {
        float floatOriginX = (float)(intOriginX - this.transform.intX) - this.transform.fracX;
        float floatOriginY = (float)(intOriginY - this.transform.intY) - this.transform.fracY;
        float floatOriginZ = (float)(intOriginZ - this.transform.intZ) - this.transform.fracZ;
        return this.frustum.testAab(floatOriginX - floatSizeX, floatOriginY - floatSizeY, floatOriginZ - floatSizeZ, floatOriginX + floatSizeX, floatOriginY + floatSizeY, floatOriginZ + floatSizeZ);
    }

    public CameraTransform getTransform() {
        return this.transform;
    }

    public SectionPos getChunkCoord() {
        return this.chunkCoords;
    }

    public BlockPos getBlockCoord() {
        return this.blockCoords;
    }
}

