/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.world.ReadableContainerExtended;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorCache;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorSource;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorView;
import me.jellysquid.mods.sodium.client.world.biome.BiomeSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import net.fabricmc.fabric.api.blockview.v2.FabricBlockView;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.model.data.ModelDataManager;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.embeddedt.embeddium.api.ChunkMeshEvent;
import org.embeddedt.embeddium.api.MeshAppender;
import org.embeddedt.embeddium.asm.OptionalInterface;
import org.jetbrains.annotations.Nullable;

@OptionalInterface(value={FabricBlockView.class, RenderAttachedBlockView.class})
public class WorldSlice
implements BlockAndTintGetter,
BiomeColorView,
FabricBlockView,
RenderAttachedBlockView {
    private static final LightLayer[] LIGHT_TYPES = LightLayer.values();
    private static final int SECTION_BLOCK_COUNT = 4096;
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private static final int NEIGHBOR_CHUNK_RADIUS = Mth.roundToward((int)2, (int)16) >> 4;
    private static final int SECTION_ARRAY_LENGTH = 1 + NEIGHBOR_CHUNK_RADIUS * 2;
    private static final int SECTION_ARRAY_SIZE = SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH;
    private static final int BLOCK_ARRAY_LENGTH = SECTION_ARRAY_LENGTH * 16;
    private static final int LOCAL_XYZ_BITS = 4;
    private static final BlockState EMPTY_BLOCK_STATE = Blocks.AIR.defaultBlockState();
    public final ClientLevel world;
    private final BiomeSlice biomeSlice;
    private final BiomeColorCache biomeColors;
    private final BlockState[][] blockArrays;
    @Nullable
    private final DataLayer[][] lightArrays;
    @Nullable
    private final Int2ReferenceMap<BlockEntity>[] blockEntityArrays;
    @Nullable
    private final Int2ReferenceMap<Object>[] blockEntityRenderDataArrays;
    @Nullable
    private final AuxiliaryLightManager[] auxLightArrays;
    private ModelDataManager.Snapshot modelDataSnapshot;
    private int originX;
    private int originY;
    private int originZ;
    private BoundingBox volume;

    public static ChunkRenderContext prepare(Level world, SectionPos origin, ClonedChunkSectionCache sectionCache) {
        boolean isEmpty;
        LevelChunk chunk = world.getChunk(origin.getX(), origin.getZ());
        LevelChunkSection section = chunk.getSections()[world.getSectionIndexFromSectionY(origin.getY())];
        List<MeshAppender> meshAppenders = ChunkMeshEvent.post(world, origin);
        boolean bl = isEmpty = (section == null || section.hasOnlyAir()) && meshAppenders.isEmpty();
        if (isEmpty) {
            return null;
        }
        BoundingBox volume = new BoundingBox(origin.minBlockX() - 2, origin.minBlockY() - 2, origin.minBlockZ() - 2, origin.maxBlockX() + 2, origin.maxBlockY() + 2, origin.maxBlockZ() + 2);
        int minChunkX = origin.getX() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkY = origin.getY() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkZ = origin.getZ() - NEIGHBOR_CHUNK_RADIUS;
        int maxChunkX = origin.getX() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkY = origin.getY() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkZ = origin.getZ() + NEIGHBOR_CHUNK_RADIUS;
        ClonedChunkSection[] sections = new ClonedChunkSection[SECTION_ARRAY_SIZE];
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    sections[WorldSlice.getLocalSectionIndex((int)(chunkX - minChunkX), (int)(chunkY - minChunkY), (int)(chunkZ - minChunkZ))] = sectionCache.acquire(chunkX, chunkY, chunkZ);
                }
            }
        }
        ModelDataManager.Snapshot snapshot = world.getModelDataManager().snapshotSectionRegion(minChunkX, minChunkY, minChunkZ, maxChunkX, maxChunkY, maxChunkZ);
        return new ChunkRenderContext(origin, sections, volume).withMeshAppenders(meshAppenders).withModelDataSnapshot(snapshot);
    }

    public WorldSlice(ClientLevel world) {
        this.world = world;
        this.blockArrays = new BlockState[SECTION_ARRAY_SIZE][4096];
        this.lightArrays = new DataLayer[SECTION_ARRAY_SIZE][LIGHT_TYPES.length];
        this.auxLightArrays = new AuxiliaryLightManager[SECTION_ARRAY_SIZE];
        this.blockEntityArrays = new Int2ReferenceMap[SECTION_ARRAY_SIZE];
        this.blockEntityRenderDataArrays = new Int2ReferenceMap[SECTION_ARRAY_SIZE];
        this.biomeSlice = new BiomeSlice();
        this.biomeColors = new BiomeColorCache(this.biomeSlice, (Integer)Minecraft.getInstance().options.biomeBlendRadius().get());
        for (Object[] objectArray : this.blockArrays) {
            Arrays.fill(objectArray, EMPTY_BLOCK_STATE);
        }
    }

    public void copyData(ChunkRenderContext context) {
        this.originX = context.getOrigin().getX() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.originY = context.getOrigin().getY() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.originZ = context.getOrigin().getZ() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.volume = context.getVolume();
        for (int x = 0; x < SECTION_ARRAY_LENGTH; ++x) {
            for (int y = 0; y < SECTION_ARRAY_LENGTH; ++y) {
                for (int z = 0; z < SECTION_ARRAY_LENGTH; ++z) {
                    this.copySectionData(context, WorldSlice.getLocalSectionIndex(x, y, z));
                }
            }
        }
        this.biomeSlice.update(this.world, context);
        this.biomeColors.update(context);
        this.modelDataSnapshot = context.getModelDataSnapshot();
    }

    private void copySectionData(ChunkRenderContext context, int sectionIndex) {
        ClonedChunkSection section = context.getSections()[sectionIndex];
        Objects.requireNonNull(section, "Chunk section must be non-null");
        try {
            this.unpackBlockData(this.blockArrays[sectionIndex], context, section);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Exception copying block data for section: " + section.getPosition(), e);
        }
        this.lightArrays[sectionIndex][LightLayer.BLOCK.ordinal()] = section.getLightArray(LightLayer.BLOCK);
        this.lightArrays[sectionIndex][LightLayer.SKY.ordinal()] = section.getLightArray(LightLayer.SKY);
        this.blockEntityArrays[sectionIndex] = section.getBlockEntityMap();
        this.blockEntityRenderDataArrays[sectionIndex] = section.getBlockEntityRenderDataMap();
        this.auxLightArrays[sectionIndex] = section.getAuxLightManager();
    }

    private void unpackBlockData(BlockState[] blockArray, ChunkRenderContext context, ClonedChunkSection section) {
        SectionPos pos;
        if (section.getBlockData() == null) {
            Arrays.fill(blockArray, EMPTY_BLOCK_STATE);
            return;
        }
        ReadableContainerExtended<BlockState> container = ReadableContainerExtended.of(section.getBlockData());
        SectionPos origin = context.getOrigin();
        if (origin.equals((Object)(pos = section.getPosition()))) {
            container.sodium$unpack((BlockState[])blockArray);
        } else {
            BoundingBox bounds = context.getVolume();
            int minBlockX = Math.max(bounds.minX(), pos.minBlockX());
            int maxBlockX = Math.min(bounds.maxX(), pos.maxBlockX());
            int minBlockY = Math.max(bounds.minY(), pos.minBlockY());
            int maxBlockY = Math.min(bounds.maxY(), pos.maxBlockY());
            int minBlockZ = Math.max(bounds.minZ(), pos.minBlockZ());
            int maxBlockZ = Math.min(bounds.maxZ(), pos.maxBlockZ());
            container.sodium$unpack((BlockState[])blockArray, minBlockX & 0xF, minBlockY & 0xF, minBlockZ & 0xF, maxBlockX & 0xF, maxBlockY & 0xF, maxBlockZ & 0xF);
        }
    }

    public void reset() {
        for (int sectionIndex = 0; sectionIndex < SECTION_ARRAY_LENGTH; ++sectionIndex) {
            Arrays.fill(this.lightArrays[sectionIndex], null);
            this.blockEntityArrays[sectionIndex] = null;
        }
        this.modelDataSnapshot = null;
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.getBlockState(pos.getX(), pos.getY(), pos.getZ());
    }

    public BlockState getBlockState(int x, int y, int z) {
        int relX = x - this.originX;
        int relY = y - this.originY;
        int relZ = z - this.originZ;
        if (!this.isInside(relX, relY, relZ)) {
            return EMPTY_BLOCK_STATE;
        }
        return this.blockArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)][WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF)];
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }

    public float getShade(Direction direction, boolean shaded) {
        return this.world.getShade(direction, shaded);
    }

    public float getShade(float normalX, float normalY, float normalZ, boolean shade) {
        return this.world.getShade(normalX, normalY, normalZ, shade);
    }

    public LevelLightEngine getLightEngine() {
        throw new UnsupportedOperationException();
    }

    public int getBrightness(LightLayer type, BlockPos pos) {
        int relZ;
        int relY;
        int relX = pos.getX() - this.originX;
        if (!this.isInside(relX, relY = pos.getY() - this.originY, relZ = pos.getZ() - this.originZ)) {
            return 0;
        }
        DataLayer lightArray = this.lightArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)][type.ordinal()];
        if (lightArray == null) {
            return 0;
        }
        return lightArray.get(relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public int getRawBrightness(BlockPos pos, int ambientDarkness) {
        int relZ;
        int relY;
        int relX = pos.getX() - this.originX;
        if (!this.isInside(relX, relY = pos.getY() - this.originY, relZ = pos.getZ() - this.originZ)) {
            return 0;
        }
        DataLayer[] lightArrays = this.lightArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)];
        DataLayer skyLightArray = lightArrays[LightLayer.SKY.ordinal()];
        DataLayer blockLightArray = lightArrays[LightLayer.BLOCK.ordinal()];
        int localX = relX & 0xF;
        int localY = relY & 0xF;
        int localZ = relZ & 0xF;
        int skyLight = skyLightArray == null ? 0 : skyLightArray.get(localX, localY, localZ) - ambientDarkness;
        int blockLight = blockLightArray == null ? 0 : blockLightArray.get(localX, localY, localZ);
        return Math.max(blockLight, skyLight);
    }

    public BlockEntity getBlockEntity(BlockPos pos) {
        return this.getBlockEntity(pos.getX(), pos.getY(), pos.getZ());
    }

    public BlockEntity getBlockEntity(int x, int y, int z) {
        int relX = x - this.originX;
        int relY = y - this.originY;
        int relZ = z - this.originZ;
        if (!this.isInside(relX, relY, relZ)) {
            return null;
        }
        Int2ReferenceMap<BlockEntity> blockEntities = this.blockEntityArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)];
        if (blockEntities == null) {
            return null;
        }
        return (BlockEntity)blockEntities.get(WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF));
    }

    public int getBlockTint(BlockPos pos, ColorResolver resolver) {
        return this.biomeColors.getColor(resolver, pos.getX(), pos.getY(), pos.getZ());
    }

    public int getHeight() {
        return this.world.getHeight();
    }

    public int getMinBuildHeight() {
        return this.world.getMinBuildHeight();
    }

    @Override
    public int getColor(BiomeColorSource source, int x, int y, int z) {
        return this.biomeColors.getColor(source, x, y, z);
    }

    public ModelDataManager.Snapshot getModelDataManager() {
        return this.modelDataSnapshot;
    }

    @Nullable
    public AuxiliaryLightManager getAuxLightManager(ChunkPos pos) {
        if (pos.x < this.volume.minX() >> 4 || pos.x > this.volume.maxX() >> 4 || pos.z < this.volume.minZ() >> 4 || pos.z > this.volume.maxZ() >> 4) {
            return null;
        }
        return this.auxLightArrays[WorldSlice.getLocalSectionIndex(pos.x - (this.originX >> 4), 0, pos.z - (this.originZ >> 4))];
    }

    public Holder<Biome> getBiomeFabric(BlockPos pos) {
        return this.biomeSlice.getBiome(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean hasBiomes() {
        return true;
    }

    public Object getBlockEntityRenderData(BlockPos pos) {
        int relZ;
        int relY;
        int relX = pos.getX() - this.originX;
        if (!this.isInside(relX, relY = pos.getY() - this.originY, relZ = pos.getZ() - this.originZ)) {
            return null;
        }
        Int2ReferenceMap<Object> blockEntityRenderDataMap = this.blockEntityRenderDataArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)];
        if (blockEntityRenderDataMap == null) {
            return null;
        }
        return blockEntityRenderDataMap.get(WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF));
    }

    public static int getLocalBlockIndex(int x, int y, int z) {
        return y << 4 << 4 | z << 4 | x;
    }

    public static int getLocalSectionIndex(int x, int y, int z) {
        return y * SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH + z * SECTION_ARRAY_LENGTH + x;
    }

    private boolean isInside(int relX, int relY, int relZ) {
        return relX >= 0 && relX < BLOCK_ARRAY_LENGTH && relZ >= 0 && relZ < BLOCK_ARRAY_LENGTH && relY >= 0 && relY < BLOCK_ARRAY_LENGTH;
    }
}

