/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import java.util.concurrent.CompletableFuture;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.compatibility.checks.ResourcePackScanner;
import me.jellysquid.mods.sodium.client.gui.screen.ConfigCorruptedScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.main.GameConfig;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.lwjgl.opengl.GL32C;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MinecraftClientMixin {
    @Shadow
    @Final
    private ReloadableResourceManager resourceManager;
    @Unique
    private final LongArrayFIFOQueue fences = new LongArrayFIFOQueue();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void postInit(GameConfig args, CallbackInfo ci) {
        if (SodiumClientMod.options().isReadOnly()) {
            Screen parent = Minecraft.getInstance().screen;
            Minecraft.getInstance().setScreen((Screen)new ConfigCorruptedScreen(() -> parent));
        }
    }

    @Inject(method={"runTick"}, at={@At(value="HEAD")})
    private void preRender(boolean tick, CallbackInfo ci) {
        ProfilerFiller profiler = Minecraft.getInstance().getProfiler();
        profiler.push("wait_for_gpu");
        while (this.fences.size() > SodiumClientMod.options().advanced.cpuRenderAheadLimit) {
            long fence = this.fences.dequeueLong();
            GL32C.glClientWaitSync((long)fence, (int)1, (long)Long.MAX_VALUE);
            GL32C.glDeleteSync((long)fence);
        }
        profiler.pop();
    }

    @Inject(method={"runTick"}, at={@At(value="RETURN")})
    private void postRender(boolean tick, CallbackInfo ci) {
        long fence = GL32C.glFenceSync((int)37143, (int)0);
        if (fence == 0L) {
            throw new RuntimeException("Failed to create fence object");
        }
        this.fences.enqueue(fence);
    }

    @Inject(method={"buildInitialScreens"}, at={@At(value="TAIL")})
    private void postInit(CallbackInfoReturnable<Runnable> cir) {
        ResourcePackScanner.checkIfCoreShaderLoaded((ResourceManager)this.resourceManager);
    }

    @Inject(method={"reloadResourcePacks()Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="TAIL")})
    private void postResourceReload(CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        ResourcePackScanner.checkIfCoreShaderLoaded((ResourceManager)this.resourceManager);
    }
}

