/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class PromptScreen
extends Screen {
    private final Screen prevScreen;
    private final int promptWidth;
    private final int promptHeight;
    private final Action action;
    private final List<FormattedText> text;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget actionButton;

    public PromptScreen(Screen prev, List<FormattedText> promptText, int promptWidth, int promptHeight, Action action) {
        super((Component)Component.literal((String)"Prompt"));
        this.prevScreen = prev;
        this.promptWidth = promptWidth;
        this.promptHeight = promptHeight;
        this.text = promptText;
        this.action = action;
    }

    protected void repositionElements() {
        this.prevScreen.resize(this.minecraft, this.width, this.height);
        super.repositionElements();
    }

    public void init() {
        int boxX = this.prevScreen.width / 2 - this.promptWidth / 2;
        int boxY = this.prevScreen.height / 2 - this.promptHeight / 2;
        this.closeButton = new FlatButtonWidget(new Dim2i(boxX + this.promptWidth - 84, boxY + this.promptHeight - 24, 80, 20), (Component)Component.literal((String)"Close"), this::onClose);
        this.closeButton.setStyle(PromptScreen.createButtonStyle());
        this.actionButton = new FlatButtonWidget(new Dim2i(boxX + this.promptWidth - 198, boxY + this.promptHeight - 24, 110, 20), this.action.label, this::runAction);
        this.actionButton.setStyle(PromptScreen.createButtonStyle());
        this.addRenderableWidget(this.closeButton);
        this.addRenderableWidget(this.actionButton);
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.prevScreen.render(drawContext, -1, -1, delta);
        PoseStack matrices = drawContext.pose();
        matrices.pushPose();
        matrices.translate(0.0f, 0.0f, 1000.0f);
        drawContext.fill(0, 0, this.prevScreen.width, this.prevScreen.height, 0x70090909);
        matrices.translate(0.0f, 0.0f, 50.0f);
        int boxX = this.prevScreen.width / 2 - this.promptWidth / 2;
        int boxY = this.prevScreen.height / 2 - this.promptHeight / 2;
        drawContext.fill(boxX, boxY, boxX + this.promptWidth, boxY + this.promptHeight, -15263977);
        drawContext.renderOutline(boxX, boxY, this.promptWidth, this.promptHeight, -15592942);
        matrices.translate(0.0f, 0.0f, 50.0f);
        int padding = 5;
        int textX = boxX + padding;
        int textY = boxY + padding;
        int textMaxWidth = this.promptWidth - padding * 2;
        int textMaxHeight = this.promptHeight - padding * 2;
        Font textRenderer = Minecraft.getInstance().font;
        for (FormattedText paragraph : this.text) {
            List formatted = textRenderer.split(paragraph, textMaxWidth);
            for (FormattedCharSequence line : formatted) {
                drawContext.drawString(textRenderer, line, textX, textY, -1, true);
                Objects.requireNonNull(textRenderer);
                textY += 9 + 2;
            }
            textY += 8;
        }
        super.render(drawContext, mouseX, mouseY, delta);
        matrices.popPose();
    }

    private static FlatButtonWidget.Style createButtonStyle() {
        FlatButtonWidget.Style style = new FlatButtonWidget.Style();
        style.bgDefault = -13948117;
        style.bgHovered = -13027015;
        style.bgDisabled = style.bgDefault;
        style.textDisabled = style.textDefault = -1;
        return style;
    }

    @NotNull
    public List<AbstractWidget> getWidgets() {
        return List.of(this.actionButton, this.closeButton);
    }

    private void runAction() {
        this.action.runnable.run();
        this.onClose();
    }

    public void onClose() {
        this.minecraft.setScreen(this.prevScreen);
    }

    public record Action(Component label, Runnable runnable) {
    }
}

