/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.taint.incompats;

import java.util.Optional;
import javax.annotation.Nullable;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public interface ModDeclaration {
    public boolean matches();

    public static class And
    implements ModDeclaration {
        private final ModDeclaration left;
        private final ModDeclaration right;

        public And(ModDeclaration left, ModDeclaration right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean matches() {
            return this.left.matches() && this.right.matches();
        }

        public String toString() {
            return this.left.toString() + " and " + this.right.toString();
        }
    }

    public static class Or
    implements ModDeclaration {
        private final ModDeclaration left;
        private final ModDeclaration right;

        public Or(ModDeclaration left, ModDeclaration right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean matches() {
            return this.left.matches() || this.right.matches();
        }

        public String toString() {
            return this.left.toString() + " or " + this.right.toString();
        }
    }

    public static class Single
    implements ModDeclaration {
        private final String modId;
        private final String friendlyName;
        private final VersionRange versionRange;

        public Single(String modId, String friendlyName) {
            this(modId, friendlyName, null);
        }

        public Single(String modId, String friendlyName, @Nullable String versionRange) {
            this.modId = modId;
            this.friendlyName = friendlyName;
            try {
                this.versionRange = versionRange == null ? null : VersionRange.createFromVersionSpec((String)versionRange);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public boolean matches() {
            Optional modContainerOpt = ModList.get().getModContainerById(this.modId);
            if (!modContainerOpt.isPresent()) {
                return false;
            }
            return this.versionRange == null || this.versionRange.containsVersion(((ModContainer)modContainerOpt.get()).getModInfo().getVersion());
        }

        public String toString() {
            if (this.versionRange == null) {
                return this.friendlyName;
            }
            return this.friendlyName + "(" + this.versionRange + ")";
        }
    }
}

