/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen;

import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import wile.redstonepen.ModContent;
import wile.redstonepen.blocks.ControlBox;
import wile.redstonepen.detail.ModRenderers;
import wile.redstonepen.detail.RcaSync;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Networking;
import wile.redstonepen.libmc.Overlay;
import wile.redstonepen.libmc.Registries;

@Mod(value="redstonepen")
public class ModRedstonePen {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)net.minecraft.core.registries.Registries.CREATIVE_MODE_TAB, (String)"redstonepen");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("tab_redstonepen", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.tabredstonepen")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> new ItemStack((ItemLike)Registries.getItem("pen"))).displayItems((parameters, output) -> Registries.getRegisteredItems().forEach(it -> {
        BlockItem bit;
        if (!(it instanceof BlockItem) || (bit = (BlockItem)it).getBlock() != ModContent.references.TRACK_BLOCK) {
            output.accept((ItemLike)it);
        }
    })).build());

    public ModRedstonePen(IEventBus bus) {
        Auxiliaries.init();
        Auxiliaries.logGitVersion();
        Registries.init();
        ModContent.init();
        bus.addListener(LiveCycleEvents::onConstruct);
        bus.addListener(LiveCycleEvents::onRegister);
        bus.addListener(LiveCycleEvents::onRegisterNetwork);
        CREATIVE_MODE_TABS.register(bus);
    }

    @Mod.EventBusSubscriber(modid="redstonepen", value={Dist.CLIENT})
    public static class ClientGameEvents {
        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
            Overlay.TextOverlayGui.INSTANCE.onRenderGui(event.getGuiGraphics());
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onRenderWorldOverlay(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_MIPPED_BLOCKS_BLOCKS) {
                Overlay.TextOverlayGui.INSTANCE.onRenderWorldOverlay(event.getPoseStack(), event.getPartialTick());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="redstonepen", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            Networking.OverlayTextMessage.setHandler(Overlay.TextOverlayGui::show);
            Overlay.TextOverlayGui.on_config(0.75, 0xFFAA00, 0x55333333, 0x55333333, 0x55444444);
            BlockEntityRenderers.register(Registries.getBlockEntityTypeOfBlock("track"), ModRenderers.TrackTer::new);
            if (RcaSync.ClientRca.init()) {
                NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, ev -> {
                    if (ev.phase != TickEvent.Phase.END) {
                        return;
                    }
                    RcaSync.ClientRca.tick();
                });
            }
        }

        @SubscribeEvent
        public static void onRegisterMenuScreens(RegisterMenuScreensEvent event) {
            event.register(Registries.getMenuTypeOfBlock("control_box"), ControlBox.ControlBoxGui::new);
        }

        @SubscribeEvent
        public static void onRegisterModels(ModelEvent.RegisterAdditional event) {
            ModRenderers.TrackTer.registerModels().forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        }
    }

    private static class LiveCycleEvents {
        private LiveCycleEvents() {
        }

        private static void onConstruct(FMLConstructModEvent event) {
            RcaSync.CommonRca.init();
        }

        private static void onRegister(RegisterEvent event) {
            String registry_name = Registries.instantiate(event.getRegistry());
            if (!registry_name.isEmpty()) {
                ModContent.initReferences(registry_name);
            }
        }

        private static void onRegisterNetwork(RegisterPayloadHandlerEvent event) {
            Networking.init(event);
        }

        private static void onLoadComplete(FMLLoadCompleteEvent event) {
        }
    }
}

