/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import wile.redstonepen.ModContent;
import wile.redstonepen.blocks.RedstoneTrack;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Overlay;
import wile.redstonepen.libmc.RsSignals;
import wile.redstonepen.libmc.StandardBlocks;

public class CircuitComponents {

    public static class BridgeRelayBlock
    extends RelayBlock {
        private int power_update_recursion_level_ = 0;

        public BridgeRelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        protected int getInputPower(Level world, BlockPos relay_pos, Direction redstone_side) {
            BlockPos pos = relay_pos.relative(redstone_side);
            BlockState state = world.getBlockState(pos);
            int p = 0;
            if (this.power_update_recursion_level_ < 32) {
                ++this.power_update_recursion_level_;
                if (state.is(Blocks.REDSTONE_WIRE)) {
                    p = Math.max(0, state.getDirectSignal((BlockGetter)world, pos, redstone_side) - 2);
                } else if (state.is((Block)ModContent.references.TRACK_BLOCK)) {
                    p = Math.max(0, RedstoneTrack.RedstoneTrackBlock.tile((BlockGetter)world, pos).map(te -> te.getRedstonePower(redstone_side, true)).orElse(0) - 2);
                } else if (state.is((Block)ModContent.references.BRIDGE_RELAY_BLOCK)) {
                    p = state.getValue((Property)FACING) != world.getBlockState(relay_pos).getValue((Property)FACING) ? 0 : (((Integer)state.getValue((Property)ROTATION) & 1) != ((Integer)world.getBlockState(relay_pos).getValue((Property)ROTATION) & 1) ? 0 : this.getInputPower(world, pos, redstone_side));
                } else {
                    p = state.getSignal((BlockGetter)world, pos, redstone_side);
                    if (p < 15 && !state.isSignalSource() && RsSignals.canEmitWeakPower(state, world, pos, redstone_side)) {
                        for (Direction d : Direction.values()) {
                            if (d != redstone_side.getOpposite() && (p = Math.max(p, world.getBlockState(pos.relative(d)).getDirectSignal((BlockGetter)world, pos.relative(d), d))) >= 15) break;
                        }
                    }
                }
                if (--this.power_update_recursion_level_ < 0) {
                    this.power_update_recursion_level_ = 0;
                }
            }
            return p;
        }

        protected boolean isWireConnected(Level world, BlockPos relay_pos, Direction side) {
            BlockPos pos = relay_pos.relative(side);
            BlockState state = world.getBlockState(pos);
            return state.is(Blocks.REDSTONE_WIRE) || state.is((Block)ModContent.references.TRACK_BLOCK);
        }

        protected boolean isSidePowered(Level world, BlockPos pos, Direction side) {
            return world.getSignal(pos.relative(side), side) > 0;
        }

        @Override
        protected boolean isPowered(BlockState state, Level world, BlockPos pos) {
            return this.isSidePowered(world, pos, (Direction)state.getValue((Property)FACING)) || this.isSidePowered(world, pos, BridgeRelayBlock.getOutputFacing(state).getOpposite());
        }

        @Override
        public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            if (redstone_side == BridgeRelayBlock.getOutputFacing(state).getOpposite()) {
                return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
            }
            if (!(world instanceof ServerLevel)) {
                return 0;
            }
            ServerLevel sworld = (ServerLevel)world;
            Direction left = BridgeRelayBlock.getLeftFacing(state);
            Direction right = BridgeRelayBlock.getRightFacing(state);
            if (redstone_side != left && redstone_side != right) {
                return 0;
            }
            if (this.isWireConnected((Level)sworld, pos, redstone_side)) {
                return this.getInputPower((Level)sworld, pos, redstone_side);
            }
            if (world.getBlockState(pos.relative(redstone_side)).isSignalSource()) {
                return this.getInputPower((Level)sworld, pos, left);
            }
            return 0;
        }

        @Override
        public int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return this.getSignal(state, world, pos, redstone_side);
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered != (Boolean)state.getValue((Property)POWERED)) {
                if (!world.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
                    if (powered) {
                        state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
                        world.setBlock(pos, state, 18);
                        world.neighborChanged(pos.relative(BridgeRelayBlock.getOutputFacing(state)), (Block)this, pos);
                    } else {
                        world.scheduleTick(pos, (Block)this, 2);
                    }
                }
                return state;
            }
            if (fromPos != null) {
                BlockPos v = pos.subtract((Vec3i)fromPos);
                Direction redstone_side = Direction.getNearest((float)v.getX(), (float)v.getY(), (float)v.getZ());
                Direction left = BridgeRelayBlock.getLeftFacing(state);
                Direction right = BridgeRelayBlock.getRightFacing(state);
                if (redstone_side != left && redstone_side != right) {
                    return state;
                }
                this.power_update_recursion_level_ = 0;
                BlockPos npos = pos.relative(redstone_side);
                world.getBlockState(npos).neighborChanged(world, npos, (Block)this, pos, false);
                int pr = this.getInputPower(world, pos, right);
                int pl = this.getInputPower(world, pos, left);
                boolean track_powered = pr > 0 || pl > 0;
                if (track_powered != ((Integer)state.getValue((Property)STATE) == 1)) {
                    state = (BlockState)state.setValue((Property)STATE, (Comparable)Integer.valueOf(track_powered ? 1 : 0));
                    world.setBlock(pos, state, 18);
                }
            }
            return state;
        }
    }

    public static class PulseRelayBlock
    extends RelayBlock {
        public PulseRelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return (Integer)state.getValue((Property)STATE) == 0 || redstone_side != PulseRelayBlock.getOutputFacing(state).getOpposite() ? 0 : 15;
        }

        @Override
        public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
            if ((Integer)state.getValue((Property)STATE) == 0) {
                return;
            }
            state = (BlockState)state.setValue((Property)STATE, (Comparable)Integer.valueOf(0));
            world.setBlock(pos, state, 18);
            this.notifyOutputNeighbourOfStateChange(state, (Level)world, pos);
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered != (Boolean)state.getValue((Property)POWERED)) {
                state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered));
                if (powered) {
                    boolean trig = (Integer)state.getValue((Property)STATE) == 0;
                    state = (BlockState)state.setValue((Property)STATE, (Comparable)Integer.valueOf(1));
                    world.setBlock(pos, state, 18);
                    if (trig) {
                        this.notifyOutputNeighbourOfStateChange(state, world, pos);
                    }
                } else {
                    world.setBlock(pos, state, 18);
                }
            }
            if (!world.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
                world.scheduleTick(pos, (Block)this, 2);
            }
            return state;
        }
    }

    public static class BistableRelayBlock
    extends RelayBlock {
        public BistableRelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return (Integer)state.getValue((Property)STATE) == 0 || redstone_side != BistableRelayBlock.getOutputFacing(state).getOpposite() ? 0 : 15;
        }

        @Override
        public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean pwstate;
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (pwstate = ((Boolean)state.getValue((Property)POWERED)).booleanValue())) {
                return state;
            }
            state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered));
            if (powered && !pwstate) {
                state = (BlockState)state.setValue((Property)STATE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)STATE) == 0 ? 1 : 0));
                world.setBlock(pos, state, 18);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
            } else if (!powered && pwstate) {
                world.setBlock(pos, state, 18);
            }
            return state;
        }
    }

    public static class InvertedRelayBlock
    extends RelayBlock {
        public InvertedRelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return (Boolean)state.getValue((Property)POWERED) != false || redstone_side != InvertedRelayBlock.getOutputFacing(state).getOpposite() ? 0 : 15;
        }

        @Override
        public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
            boolean powered = this.isPowered(state, (Level)world, pos);
            if (powered == (Boolean)state.getValue((Property)POWERED)) {
                return;
            }
            if (powered) {
                world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 18);
                this.notifyOutputNeighbourOfStateChange(state, (Level)world, pos);
            }
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (Boolean)state.getValue((Property)POWERED)) {
                return state;
            }
            if (world.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
                return state;
            }
            if (powered) {
                world.scheduleTick(pos, (Block)this, 2);
            } else {
                world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 18);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
            }
            return state;
        }
    }

    public static class RelayBlock
    extends DirectedComponentBlock {
        protected boolean isPowered(BlockState state, Level world, BlockPos pos) {
            Direction output_side = RelayBlock.getOutputFacing(state);
            Direction mount_side = (Direction)state.getValue((Property)FACING);
            for (Direction side : Direction.values()) {
                if (side == output_side || side == mount_side.getOpposite() || world.getSignal(pos.relative(side), side) <= 0) continue;
                return true;
            }
            return false;
        }

        public RelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return (Boolean)state.getValue((Property)POWERED) == false || redstone_side != RelayBlock.getOutputFacing(state).getOpposite() ? 0 : 15;
        }

        @Override
        public int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return this.getSignal(state, world, pos, redstone_side);
        }

        @Override
        public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
            boolean powered = this.isPowered(state, (Level)world, pos);
            if (powered == (Boolean)state.getValue((Property)POWERED)) {
                return;
            }
            if (!powered) {
                world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 18);
                this.notifyOutputNeighbourOfStateChange(state, (Level)world, pos);
            }
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (Boolean)state.getValue((Property)POWERED)) {
                return state;
            }
            if (world.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
                return state;
            }
            if (powered) {
                world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 18);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
            } else {
                world.scheduleTick(pos, (Block)this, 2);
            }
            return state;
        }
    }

    public static class DirectedComponentBlockItem
    extends BlockItem {
        public DirectedComponentBlockItem(Block block, Item.Properties builder) {
            super(block, builder);
        }

        public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
            if (!(isSelected && world.isClientSide && entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            Inventory inv = player.getInventory();
            int sel_index = inv.selected;
            if (sel_index < 0 || sel_index >= inv.getContainerSize()) {
                return;
            }
            if (!inv.getItem(sel_index).is(stack.getItem())) {
                return;
            }
            BlockHitResult hr = DirectedComponentBlockItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            BlockPlaceContext pc = new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, hr));
            if (!pc.canPlace()) {
                return;
            }
            BlockState state = this.getBlock().getStateForPlacement(pc);
            if (state == null) {
                return;
            }
            Overlay.show(state, pc.getClickedPos());
        }
    }

    public static class DirectedComponentBlock
    extends StandardBlocks.WaterLoggable {
        public static final DirectionProperty FACING = BlockStateProperties.FACING;
        public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)0, (int)3);
        public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
        public static final IntegerProperty STATE = IntegerProperty.create((String)"state", (int)0, (int)1);
        private static final List<Direction> facing_mapping_ = DirectedComponentBlock.make_facing_mappings();
        private static final Direction[][][] facing_fwd_state_mapping_ = new Direction[6][4][6];
        private static final Direction[][][] facing_rev_state_mapping_ = new Direction[6][4][6];
        protected final Map<BlockState, VoxelShape> shapes_ = new HashMap<BlockState, VoxelShape>();

        private static List<Direction> make_facing_mappings() {
            ArrayList<Direction> maps = new ArrayList<Direction>();
            Arrays.stream(Direction.values()).forEach(face -> {
                switch (face) {
                    case DOWN: 
                    case UP: {
                        maps.add(Direction.NORTH);
                        maps.add(Direction.EAST);
                        maps.add(Direction.SOUTH);
                        maps.add(Direction.WEST);
                        break;
                    }
                    case NORTH: {
                        maps.add(Direction.UP);
                        maps.add(Direction.EAST);
                        maps.add(Direction.DOWN);
                        maps.add(Direction.WEST);
                        break;
                    }
                    case EAST: {
                        maps.add(Direction.UP);
                        maps.add(Direction.SOUTH);
                        maps.add(Direction.DOWN);
                        maps.add(Direction.NORTH);
                        break;
                    }
                    case SOUTH: {
                        maps.add(Direction.UP);
                        maps.add(Direction.WEST);
                        maps.add(Direction.DOWN);
                        maps.add(Direction.EAST);
                        break;
                    }
                    case WEST: {
                        maps.add(Direction.UP);
                        maps.add(Direction.NORTH);
                        maps.add(Direction.DOWN);
                        maps.add(Direction.SOUTH);
                    }
                }
            });
            return maps;
        }

        private static void fill_state_facing_lookups(ImmutableList<BlockState> states) {
            if (facing_fwd_state_mapping_[0][0][0] != null && facing_rev_state_mapping_[0][0][0] != null) {
                return;
            }
            for (BlockState state : states) {
                for (Direction world_side : Direction.values()) {
                    Direction sm;
                    DirectedComponentBlock.facing_fwd_state_mapping_[((Direction)state.getValue((Property)DirectedComponentBlock.FACING)).ordinal()][((Integer)state.getValue((Property)DirectedComponentBlock.ROTATION)).intValue()][world_side.ordinal()] = sm = (switch (world_side) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.DOWN -> DirectedComponentBlock.getDownFacing(state);
                        case Direction.UP -> DirectedComponentBlock.getUpFacing(state);
                        case Direction.NORTH -> DirectedComponentBlock.getFrontFacing(state);
                        case Direction.SOUTH -> DirectedComponentBlock.getBackFacing(state);
                        case Direction.WEST -> DirectedComponentBlock.getLeftFacing(state);
                        case Direction.EAST -> DirectedComponentBlock.getRightFacing(state);
                    });
                    DirectedComponentBlock.facing_rev_state_mapping_[((Direction)state.getValue((Property)DirectedComponentBlock.FACING)).ordinal()][((Integer)state.getValue((Property)DirectedComponentBlock.ROTATION)).intValue()][sm.ordinal()] = world_side;
                }
            }
        }

        protected static VoxelShape mapped_shape(BlockState state, AABB[] aabb) {
            switch ((Direction)state.getValue((Property)FACING)) {
                case DOWN: {
                    switch ((Integer)state.getValue((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 0));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 2));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 3));
                        }
                    }
                }
                case UP: {
                    switch ((Integer)state.getValue((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 0), Direction.Axis.Y));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 1), Direction.Axis.Y));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 2), Direction.Axis.Y));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 3), Direction.Axis.Y));
                        }
                    }
                }
                case NORTH: {
                    switch ((Integer)state.getValue((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.SOUTH), Direction.DOWN));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.DOWN));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.NORTH), Direction.DOWN));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.EAST), Direction.DOWN));
                        }
                    }
                }
                case EAST: {
                    switch ((Integer)state.getValue((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.UP), Direction.WEST), 0));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.DOWN), 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.SOUTH), Direction.UP), 3));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.UP), 3));
                        }
                    }
                }
                case SOUTH: {
                    switch ((Integer)state.getValue((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.NORTH), Direction.UP));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.EAST), Direction.UP));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.SOUTH), Direction.UP));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.UP));
                        }
                    }
                }
                case WEST: {
                    switch ((Integer)state.getValue((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.UP), Direction.EAST));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.EAST), Direction.UP), 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.DOWN), Direction.WEST));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.UP), 1));
                        }
                    }
                }
            }
            return Shapes.block();
        }

        public DirectedComponentBlock(long config, BlockBehaviour.Properties builder, AABB[] aabbs) {
            super(config, builder.pushReaction(PushReaction.DESTROY));
            this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)super.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)STATE, (Comparable)Integer.valueOf(0)));
            this.stateDefinition.getPossibleStates().forEach(state -> this.shapes_.put((BlockState)state, DirectedComponentBlock.mapped_shape(state, aabbs)));
            DirectedComponentBlock.fill_state_facing_lookups((ImmutableList<BlockState>)this.stateDefinition.getPossibleStates());
        }

        public DirectedComponentBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            this(config, builder, new AABB[]{aabb});
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{FACING, ROTATION, POWERED, STATE});
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, @Nullable BlockEntity te, boolean explosion) {
            return Collections.singletonList(new ItemStack((ItemLike)this.asItem()));
        }

        @Override
        public boolean isPathfindable(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
            return true;
        }

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return this.shapes_.getOrDefault(state, Shapes.block());
        }

        @Override
        public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return this.getShape(state, world, pos, context);
        }

        public VoxelShape getOcclusionShape(BlockState state, BlockGetter world, BlockPos pos) {
            return this.shapes_.getOrDefault(state, Shapes.block());
        }

        @Override
        public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
            return (Boolean)state.getValue((Property)WATERLOGGED) == false;
        }

        public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
            return side == null || side != state.getValue((Property)FACING);
        }

        public boolean isSignalSource(BlockState state) {
            return true;
        }

        public boolean hasAnalogOutputSignal(BlockState state) {
            return false;
        }

        public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
            return 0;
        }

        public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return 0;
        }

        public int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return 0;
        }

        public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
        }

        @Override
        @Nullable
        public BlockState getStateForPlacement(BlockPlaceContext context) {
            BlockState state = super.getStateForPlacement(context);
            if (state == null) {
                return null;
            }
            Direction face = context.getClickedFace().getOpposite();
            Vec3 hit_r = context.getClickLocation().subtract(Vec3.atCenterOf((Vec3i)context.getClickedPos()));
            Vec3 hit = switch (face) {
                case Direction.WEST, Direction.EAST -> hit_r.multiply(0.0, 1.0, 1.0);
                case Direction.NORTH, Direction.SOUTH -> hit_r.multiply(1.0, 1.0, 0.0);
                default -> hit_r.multiply(1.0, 0.0, 1.0);
            };
            Direction dir = Direction.getNearest((double)hit.x(), (double)hit.y(), (double)hit.z());
            int rotation = 0;
            block4 : switch (face) {
                case DOWN: 
                case UP: {
                    switch (dir) {
                        case EAST: {
                            rotation = 1;
                            break block4;
                        }
                        case SOUTH: {
                            rotation = 2;
                            break block4;
                        }
                        case WEST: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case NORTH: {
                    switch (dir) {
                        case EAST: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case WEST: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case EAST: {
                    switch (dir) {
                        case SOUTH: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case NORTH: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case SOUTH: {
                    switch (dir) {
                        case WEST: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case EAST: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case WEST: {
                    switch (dir) {
                        case NORTH: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case SOUTH: {
                            rotation = 3;
                            break block4;
                        }
                    }
                }
            }
            state = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)face)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)STATE, (Comparable)Integer.valueOf(0));
            if (!this.canSurvive(state, (LevelReader)context.getLevel(), context.getClickedPos())) {
                return null;
            }
            return state;
        }

        @Override
        public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            BlockState blockState;
            if ((state = super.updateShape(state, facing, facingState, world, pos, facingPos)) == null) {
                return state;
            }
            if (!this.canSurvive(state, (LevelReader)world, pos)) {
                return Blocks.AIR.defaultBlockState();
            }
            if (world instanceof ServerLevel) {
                ServerLevel sworld = (ServerLevel)world;
                blockState = this.update(state, (Level)sworld, pos, facingPos);
            } else {
                blockState = state;
            }
            return blockState;
        }

        public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
            Direction face = (Direction)state.getValue((Property)FACING);
            BlockPos adj_pos = pos.relative(face);
            return world.getBlockState(adj_pos).isFaceSturdy((BlockGetter)world, adj_pos, face.getOpposite());
        }

        public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
            this.update(state, world, pos, null);
        }

        @Override
        public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (isMoving || state.is(newState.getBlock())) {
                return;
            }
            super.onRemove(state, world, pos, newState, isMoving);
            if (!world.isClientSide()) {
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
                world.updateNeighborsAt(pos, (Block)this);
            }
        }

        public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
            return false;
        }

        public void neighborChanged(BlockState state, Level world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
            this.update(state, world, pos, fromPos);
        }

        @OnlyIn(value=Dist.CLIENT)
        private void spawnPoweredParticle(Level world, RandomSource rand, BlockPos pos, Vec3 color, Direction side, float chance) {
            if (rand.nextFloat() < chance) {
                double c2 = chance * rand.nextFloat();
                double p0 = 0.5 + (double)side.getStepX() * 0.4 + c2 * 0.1;
                double p1 = 0.5 + (double)side.getStepY() * 0.4 + c2 * 0.1;
                double p2 = 0.5 + (double)side.getStepZ() * 0.4 + c2 * 0.1;
                world.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)color.x, (float)color.y, (float)color.z), 1.0f), (double)pos.getX() + p0, (double)pos.getY() + p1, (double)pos.getZ() + p2, 0.0, 0.0, 0.0);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
            if (!((Boolean)state.getValue((Property)POWERED)).booleanValue() || (double)rand.nextFloat() > 0.4) {
                return;
            }
            Vec3 color = new Vec3((double)0.6f, 0.0, 0.0);
            Direction side = (Direction)state.getValue((Property)FACING);
            this.spawnPoweredParticle(world, rand, pos, color, side, 0.3f);
        }

        protected static Direction getOutputFacing(BlockState state) {
            return DirectedComponentBlock.getFrontFacing(state);
        }

        protected static Direction getFrontFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.getValue((Property)FACING)).get3DDataValue() * 4 + ((Integer)state.getValue((Property)ROTATION) & 3));
        }

        protected static Direction getRightFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.getValue((Property)FACING)).get3DDataValue() * 4 + ((Integer)state.getValue((Property)ROTATION) + 1 & 3));
        }

        protected static Direction getBackFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.getValue((Property)FACING)).get3DDataValue() * 4 + ((Integer)state.getValue((Property)ROTATION) + 2 & 3));
        }

        protected static Direction getLeftFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.getValue((Property)FACING)).get3DDataValue() * 4 + ((Integer)state.getValue((Property)ROTATION) + 3 & 3));
        }

        protected static Direction getUpFacing(BlockState state) {
            return ((Direction)state.getValue((Property)FACING)).getOpposite();
        }

        protected static Direction getDownFacing(BlockState state) {
            return (Direction)state.getValue((Property)FACING);
        }

        protected static Direction getForwardStateMappedFacing(BlockState state, Direction internal_side) {
            return facing_fwd_state_mapping_[((Direction)state.getValue((Property)FACING)).ordinal()][(Integer)state.getValue((Property)ROTATION)][internal_side.ordinal()];
        }

        protected static Direction getReverseStateMappedFacing(BlockState state, Direction world_side) {
            return facing_rev_state_mapping_[((Direction)state.getValue((Property)FACING)).ordinal()][(Integer)state.getValue((Property)ROTATION)][world_side.ordinal()];
        }

        protected void notifyOutputNeighbourOfStateChange(BlockState state, Level world, BlockPos pos) {
            this.notifyOutputNeighbourOfStateChange(state, world, pos, DirectedComponentBlock.getOutputFacing(state));
        }

        protected void notifyOutputNeighbourOfStateChange(BlockState state, Level world, BlockPos pos, Direction facing) {
            BlockPos adjacent_pos = pos.relative(facing);
            BlockState adjacent_state = world.getBlockState(adjacent_pos);
            try {
                adjacent_state.neighborChanged(world, adjacent_pos, (Block)this, pos, false);
                if (RsSignals.canEmitWeakPower(adjacent_state, world, adjacent_pos, facing)) {
                    world.updateNeighborsAtExceptFromFacing(adjacent_pos, state.getBlock(), facing.getOpposite());
                }
            }
            catch (Throwable ex) {
                Auxiliaries.logError("Curcuit neighborChanged recursion detected, dropping!");
                Vec3 p = Vec3.atCenterOf((Vec3i)pos);
                world.addFreshEntity((Entity)new ItemEntity(world, p.x, p.y, p.z, new ItemStack((ItemLike)this, 1)));
                world.setBlock(pos, world.getBlockState(pos).getFluidState().createLegacyBlock(), 18);
            }
        }

        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            return state;
        }
    }
}

