/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.detail;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;
import wile.api.rca.FmmRedstoneClientAdapter;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Networking;

public class RcaSync {
    private static final String MESSAGE_HANDLER_ID = "rcadata";

    public static final class ClientRca {
        public static boolean init() {
            FmmRedstoneClientAdapter.Adapter rca = FmmRedstoneClientAdapter.Adapter.instance();
            if (rca == null) {
                Auxiliaries.logInfo("Redstone Pen RCA disabled (default).");
                return false;
            }
            Networking.PacketNbtNotifyServerToClient.handlers.put(RcaSync.MESSAGE_HANDLER_ID, nbt -> {
                if (nbt.contains("o")) {
                    rca.setOutputs(nbt.getLong("o"));
                }
            });
            Auxiliaries.logInfo("Redstone Pen RCA detected and enabled on this client machine.");
            return true;
        }

        public static void tick() {
            FmmRedstoneClientAdapter.Adapter rca = FmmRedstoneClientAdapter.Adapter.instance();
            if (rca == null) {
                return;
            }
            rca.tick();
            CompoundTag nbt = new CompoundTag();
            nbt.putString("hnd", RcaSync.MESSAGE_HANDLER_ID);
            nbt.putLong("i", rca.getInputs());
            Networking.PacketNbtNotifyClientToServer.sendToServer(nbt);
            rca.setInputsChanged(false);
        }
    }

    public static final class CommonRca {
        public static final RcaData EMPTY = new RcaData(new UUID(0L, 0L));
        private static final Map<UUID, RcaData> data_cache = new HashMap<UUID, RcaData>();
        private static long num_exceptions = 0L;
        private static final long ERROR_CUTOFF_COUNT = 32L;

        public static synchronized RcaData ofPlayer(@Nullable UUID puid, boolean allow_create) {
            if (puid == null) {
                return EMPTY;
            }
            if (allow_create && !data_cache.containsKey(puid)) {
                data_cache.put(puid, new RcaData(puid));
            }
            return data_cache.getOrDefault(puid, EMPTY);
        }

        public static void init() {
            Networking.PacketNbtNotifyClientToServer.handlers.put(RcaSync.MESSAGE_HANDLER_ID, (player, nbt) -> {
                if (!nbt.contains("i") || num_exceptions >= 32L) {
                    return;
                }
                try {
                    RcaData rca = CommonRca.ofPlayer(player.getUUID(), true);
                    rca.client_inputs(nbt.getLong("i"));
                    nbt.remove("i");
                    nbt.putLong("o", rca.server_outputs());
                    Networking.PacketNbtNotifyServerToClient.sendToPlayer(player, nbt);
                }
                catch (Throwable ignored) {
                    ++num_exceptions;
                }
            });
        }
    }

    public static final class RcaData {
        public final UUID puid;
        public long client_inputs_ = 0L;
        public long client_outputs_ = 0L;
        public long server_outputs_ = 0L;

        public RcaData(UUID puid) {
            this.puid = puid;
        }

        public boolean isValid() {
            return this.puid.getLeastSignificantBits() != 0L || this.puid.getMostSignificantBits() != 0L;
        }

        public synchronized long client_inputs() {
            return this.client_inputs_;
        }

        public synchronized void client_inputs(long val) {
            this.client_inputs_ = val;
        }

        public synchronized long server_outputs() {
            return this.server_outputs_;
        }

        public synchronized void server_outputs(long val) {
            this.server_outputs_ = val;
        }

        public String toString() {
            return "{player:\"" + (this.puid == null ? "" : this.puid.toString()) + ", ci:" + String.format("%016x", this.client_inputs_) + ", co:" + String.format("%016x", this.client_outputs_) + ", so:" + String.format("%016x", this.server_outputs_) + "}";
        }
    }
}

