/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Auxiliaries {
    private static final Logger logger = LogUtils.getLogger();

    public static void init() {
    }

    public static String modid() {
        return "redstonepen";
    }

    public static Logger logger() {
        return logger;
    }

    public static boolean isModLoaded(String registry_name) {
        return ModList.get().isLoaded(registry_name);
    }

    public static boolean isDevelopmentMode() {
        return SharedConstants.IS_RUNNING_IN_IDE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isShiftDown() {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)344);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isCtrlDown() {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)341) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)345);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<String> getClipboard() {
        return Optional.of(TextFieldHelper.getClipboardContents((Minecraft)Minecraft.getInstance()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean setClipboard(String text) {
        TextFieldHelper.setClipboardContents((Minecraft)Minecraft.getInstance(), (String)text);
        return true;
    }

    public static void logInfo(String msg) {
        logger.info(msg);
    }

    public static void logWarn(String msg) {
        logger.warn(msg);
    }

    public static void logError(String msg) {
        logger.error(msg);
    }

    public static MutableComponent localizable(String modtrkey, Object ... args) {
        return Component.translatable((String)(modtrkey.startsWith("block.") || modtrkey.startsWith("item.") ? modtrkey : Auxiliaries.modid() + "." + modtrkey), (Object[])args);
    }

    public static MutableComponent localizable(String modtrkey, @Nullable ChatFormatting color, Object ... args) {
        MutableComponent tr = Component.translatable((String)(Auxiliaries.modid() + "." + modtrkey), (Object[])args);
        if (color != null) {
            tr.getStyle().applyFormat(color);
        }
        return tr;
    }

    public static Component localizable(String modtrkey) {
        return Auxiliaries.localizable(modtrkey, new Object[0]);
    }

    public static Component localizable_block_key(String blocksubkey) {
        return Component.translatable((String)("block." + Auxiliaries.modid() + "." + blocksubkey));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localize(String translationKey, Object ... args) {
        MutableComponent tr = Component.translatable((String)translationKey, (Object[])args);
        tr.getStyle().applyFormat(ChatFormatting.RESET);
        return tr.getString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasTranslation(String key) {
        return I18n.exists((String)key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<Component> wrapText(Component text, int max_width_percent) {
        int max_width = (Minecraft.getInstance().getWindow().getGuiScaledWidth() - 10) * max_width_percent / 100;
        return Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)text, max_width, Style.EMPTY).stream().map(ft -> Component.literal((String)ft.getString())).collect(Collectors.toList());
    }

    public static MutableComponent join(Collection<? extends Component> components, String separator) {
        return ComponentUtils.formatList(components, (Component)Component.literal((String)separator), Function.identity());
    }

    public static MutableComponent join(Component ... components) {
        MutableComponent tc = Component.empty();
        for (Component c : components) {
            tc.append(c);
        }
        return tc;
    }

    public static boolean isEmpty(Component component) {
        return component.getSiblings().isEmpty() && component.getString().isEmpty();
    }

    public static void playerChatMessage(Player player, String message) {
        player.displayClientMessage((Component)Component.translatable((String)message.trim()), true);
    }

    @Nullable
    public static Component unserializeTextComponent(String serialized) {
        return Component.Serializer.fromJson((String)serialized);
    }

    public static String serializeTextComponent(Component tc) {
        return tc == null ? "" : Component.Serializer.toJson((Component)tc);
    }

    public static ResourceLocation getResourceLocation(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceLocation getResourceLocation(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    @Nullable
    public static Component getItemLabel(ItemStack stack) {
        CompoundTag nbt = stack.getTagElement("display");
        if (nbt != null && nbt.contains("Name", 8)) {
            try {
                Component tc = Auxiliaries.unserializeTextComponent(nbt.getString("Name"));
                if (tc != null) {
                    return tc;
                }
                nbt.remove("Name");
            }
            catch (Exception e) {
                nbt.remove("Name");
            }
        }
        return null;
    }

    public static ItemStack setItemLabel(ItemStack stack, @Nullable Component name) {
        if (name != null) {
            CompoundTag nbt = stack.getOrCreateTagElement("display");
            nbt.putString("Name", Auxiliaries.serializeTextComponent(name));
        } else if (stack.hasTag()) {
            stack.removeTagKey("display");
        }
        return stack;
    }

    public static boolean isWaterLogged(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
    }

    public static AABB getPixeledAABB(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new AABB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
    }

    public static AABB getRotatedAABB(AABB bb, Direction new_facing) {
        return Auxiliaries.getRotatedAABB(bb, new_facing, false);
    }

    public static AABB[] getRotatedAABB(AABB[] bb, Direction new_facing) {
        return Auxiliaries.getRotatedAABB(bb, new_facing, false);
    }

    public static AABB getRotatedAABB(AABB bb, Direction new_facing, boolean horizontal_rotation) {
        if (!horizontal_rotation) {
            switch (new_facing.get3DDataValue()) {
                case 0: {
                    return new AABB(1.0 - bb.maxX, bb.minZ, bb.minY, 1.0 - bb.minX, bb.maxZ, bb.maxY);
                }
                case 1: {
                    return new AABB(1.0 - bb.maxX, 1.0 - bb.maxZ, 1.0 - bb.maxY, 1.0 - bb.minX, 1.0 - bb.minZ, 1.0 - bb.minY);
                }
                case 2: {
                    return new AABB(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
                }
                case 3: {
                    return new AABB(1.0 - bb.maxX, bb.minY, 1.0 - bb.maxZ, 1.0 - bb.minX, bb.maxY, 1.0 - bb.minZ);
                }
                case 4: {
                    return new AABB(bb.minZ, bb.minY, 1.0 - bb.maxX, bb.maxZ, bb.maxY, 1.0 - bb.minX);
                }
                case 5: {
                    return new AABB(1.0 - bb.maxZ, bb.minY, bb.minX, 1.0 - bb.minZ, bb.maxY, bb.maxX);
                }
            }
        } else {
            switch (new_facing.get3DDataValue()) {
                case 0: {
                    return new AABB(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
                }
                case 1: {
                    return new AABB(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
                }
                case 2: {
                    return new AABB(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
                }
                case 3: {
                    return new AABB(1.0 - bb.maxX, bb.minY, 1.0 - bb.maxZ, 1.0 - bb.minX, bb.maxY, 1.0 - bb.minZ);
                }
                case 4: {
                    return new AABB(bb.minZ, bb.minY, 1.0 - bb.maxX, bb.maxZ, bb.maxY, 1.0 - bb.minX);
                }
                case 5: {
                    return new AABB(1.0 - bb.maxZ, bb.minY, bb.minX, 1.0 - bb.minZ, bb.maxY, bb.maxX);
                }
            }
        }
        return bb;
    }

    public static AABB[] getRotatedAABB(AABB[] bbs, Direction new_facing, boolean horizontal_rotation) {
        AABB[] transformed = new AABB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getRotatedAABB(bbs[i], new_facing, horizontal_rotation);
        }
        return transformed;
    }

    public static AABB getYRotatedAABB(AABB bb, int clockwise_90deg_steps) {
        Direction[] direction_map = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        return Auxiliaries.getRotatedAABB(bb, direction_map[clockwise_90deg_steps + 4096 & 3], true);
    }

    public static AABB[] getYRotatedAABB(AABB[] bbs, int clockwise_90deg_steps) {
        AABB[] transformed = new AABB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getYRotatedAABB(bbs[i], clockwise_90deg_steps);
        }
        return transformed;
    }

    public static AABB getMirroredAABB(AABB bb, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new AABB(1.0 - bb.maxX, bb.minY, bb.minZ, 1.0 - bb.minX, bb.maxY, bb.maxZ);
            case Direction.Axis.Y -> new AABB(bb.minX, 1.0 - bb.maxY, bb.minZ, bb.maxX, 1.0 - bb.minY, bb.maxZ);
            case Direction.Axis.Z -> new AABB(bb.minX, bb.minY, 1.0 - bb.maxZ, bb.maxX, bb.maxY, 1.0 - bb.minZ);
        };
    }

    public static AABB[] getMirroredAABB(AABB[] bbs, Direction.Axis axis) {
        AABB[] transformed = new AABB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getMirroredAABB(bbs[i], axis);
        }
        return transformed;
    }

    public static VoxelShape getUnionShape(AABB ... aabbs) {
        VoxelShape shape2 = Shapes.empty();
        for (AABB aabb : aabbs) {
            shape2 = Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.OR);
        }
        return shape2;
    }

    public static VoxelShape getUnionShape(AABB[] ... aabb_list) {
        VoxelShape shape2 = Shapes.empty();
        AABB[][] aABBArray = aabb_list;
        int n = aABBArray.length;
        for (int i = 0; i < n; ++i) {
            AABB[] aabbs;
            for (AABB aabb : aabbs = aABBArray[i]) {
                shape2 = Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.OR);
            }
        }
        return shape2;
    }

    public static AABB[] getMappedAABB(AABB[] bbs, Function<AABB, AABB> mapper) {
        AABB[] transformed = new AABB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = mapper.apply(bbs[i]);
        }
        return transformed;
    }

    public static String loadResourceText(InputStream is) {
        try {
            if (is == null) {
                return "";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            return br.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String loadResourceText(String path) {
        return Auxiliaries.loadResourceText(Auxiliaries.class.getResourceAsStream(path));
    }

    public static void logGitVersion() {
        try {
            String version = Auxiliaries.loadResourceText("/.gitversion-redstonepen").trim();
            Auxiliaries.logInfo("Redstone Pen" + (String)(version.isEmpty() ? " (dev build)" : " GIT id #" + version) + ".");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final class BlockPosRange
    implements Iterable<BlockPos> {
        private final int x0;
        private final int x1;
        private final int y0;
        private final int y1;
        private final int z0;
        private final int z1;

        public BlockPosRange(int x0, int y0, int z0, int x1, int y1, int z1) {
            this.x0 = Math.min(x0, x1);
            this.x1 = Math.max(x0, x1);
            this.y0 = Math.min(y0, y1);
            this.y1 = Math.max(y0, y1);
            this.z0 = Math.min(z0, z1);
            this.z1 = Math.max(z0, z1);
        }

        public static BlockPosRange of(AABB range) {
            return new BlockPosRange((int)Math.floor(range.minX), (int)Math.floor(range.minY), (int)Math.floor(range.minZ), (int)Math.floor(range.maxX - 0.0625), (int)Math.floor(range.maxY - 0.0625), (int)Math.floor(range.maxZ - 0.0625));
        }

        public int getXSize() {
            return this.x1 - this.x0 + 1;
        }

        public int getYSize() {
            return this.y1 - this.y0 + 1;
        }

        public int getZSize() {
            return this.z1 - this.z0 + 1;
        }

        public int getArea() {
            return this.getXSize() * this.getZSize();
        }

        public int getHeight() {
            return this.getYSize();
        }

        public int getVolume() {
            return this.getXSize() * this.getYSize() * this.getZSize();
        }

        public BlockPos byXZYIndex(int xyz_index) {
            int xsz = this.getXSize();
            int ysz = this.getYSize();
            int zsz = this.getZSize();
            int y = (xyz_index %= xsz * ysz * zsz) / (xsz * zsz);
            int z = (xyz_index -= y * (xsz * zsz)) / xsz;
            int x = xyz_index -= z * xsz;
            return new BlockPos(this.x0 + x, this.y0 + y, this.z0 + z);
        }

        public BlockPos byXZIndex(int xz_index, int y_offset) {
            int xsz = this.getXSize();
            int zsz = this.getZSize();
            int z = (xz_index %= xsz * zsz) / xsz;
            int x = xz_index -= z * xsz;
            return new BlockPos(this.x0 + x, this.y0 + y_offset, this.z0 + z);
        }

        public BlockRangeIterator iterator() {
            return new BlockRangeIterator(this);
        }

        public Stream<BlockPos> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        public static final class BlockRangeIterator
        implements Iterator<BlockPos> {
            private final BlockPosRange range_;
            private int x;
            private int y;
            private int z;

            public BlockRangeIterator(BlockPosRange range) {
                this.range_ = range;
                this.x = range.x0;
                this.y = range.y0;
                this.z = range.z0;
            }

            @Override
            public boolean hasNext() {
                return this.z <= this.range_.z1;
            }

            @Override
            public BlockPos next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BlockPos pos = new BlockPos(this.x, this.y, this.z);
                ++this.x;
                if (this.x > this.range_.x1) {
                    this.x = this.range_.x0;
                    ++this.y;
                    if (this.y > this.range_.y1) {
                        this.y = this.range_.y0;
                        ++this.z;
                    }
                }
                return pos;
            }
        }
    }

    public static final class Tooltip {
        @OnlyIn(value=Dist.CLIENT)
        public static boolean extendedTipCondition() {
            return Auxiliaries.isShiftDown();
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean helpCondition() {
            return Auxiliaries.isShiftDown() && Auxiliaries.isCtrlDown();
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(@Nullable String advancedTooltipTranslationKey, @Nullable String helpTranslationKey, List<Component> tooltip, TooltipFlag flag, boolean addAdvancedTooltipHints) {
            String[] tip_list;
            boolean tip_available;
            boolean help_available = helpTranslationKey != null && Auxiliaries.hasTranslation(helpTranslationKey + ".help");
            boolean bl = tip_available = advancedTooltipTranslationKey != null && Auxiliaries.hasTranslation(helpTranslationKey + ".tip");
            if (!help_available && !tip_available) {
                return false;
            }
            Object tip_text = "";
            if (Tooltip.helpCondition()) {
                if (help_available) {
                    tip_text = Auxiliaries.localize(helpTranslationKey + ".help", new Object[0]);
                }
            } else if (Tooltip.extendedTipCondition()) {
                if (tip_available) {
                    tip_text = Auxiliaries.localize(advancedTooltipTranslationKey + ".tip", new Object[0]);
                }
            } else if (addAdvancedTooltipHints) {
                if (tip_available) {
                    tip_text = (String)tip_text + Auxiliaries.localize(Auxiliaries.modid() + ".tooltip.hint.extended", new Object[0]) + (help_available ? " " : "");
                }
                if (help_available) {
                    tip_text = (String)tip_text + Auxiliaries.localize(Auxiliaries.modid() + ".tooltip.hint.help", new Object[0]);
                }
            }
            if (((String)tip_text).isEmpty()) {
                return false;
            }
            for (String tip : tip_list = ((String)tip_text).split("\\r?\\n")) {
                tooltip.add((Component)Component.literal((String)tip.replaceAll("\\s+$", "").replaceAll("^\\s+", "")).withStyle(ChatFormatting.GRAY));
            }
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag, boolean addAdvancedTooltipHints) {
            return Tooltip.addInformation(stack.getDescriptionId(), stack.getDescriptionId(), tooltip, flag, addAdvancedTooltipHints);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(String translation_key, List<Component> tooltip) {
            if (!Auxiliaries.hasTranslation(translation_key)) {
                return false;
            }
            tooltip.add((Component)Component.literal((String)Auxiliaries.localize(translation_key, new Object[0]).replaceAll("\\s+$", "").replaceAll("^\\s+", "")).withStyle(ChatFormatting.GRAY));
            return true;
        }
    }

    public static interface IExperimentalFeature {
    }
}

