/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import wile.redstonepen.libmc.Auxiliaries;

public class ExtendedShapelessRecipe
extends ShapelessRecipe
implements CraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final CompoundTag aspects;
    private final ItemStack resultItem;

    public ExtendedShapelessRecipe(String group, CraftingBookCategory cat, ItemStack output, NonNullList<Ingredient> ingredients, CompoundTag aspects) {
        super(group, cat, output, ingredients);
        this.aspects = aspects;
        this.resultItem = output;
    }

    public CompoundTag getAspects() {
        return this.aspects.copy();
    }

    private int getToolDamage() {
        if (this.aspects.contains("tool_repair")) {
            return -Mth.clamp((int)this.aspects.getInt("tool_repair"), (int)0, (int)4096);
        }
        if (this.aspects.contains("tool_damage")) {
            return Mth.clamp((int)this.aspects.getInt("tool_damage"), (int)1, (int)1024);
        }
        return 0;
    }

    private boolean isRepair() {
        return this.getToolDamage() < 0;
    }

    private Tuple<ItemStack, NonNullList<ItemStack>> getRepaired(CraftingContainer inv) {
        ItemStack stack;
        int i;
        String tool_name = this.aspects.getString("tool");
        HashMap<Item, Integer> repair_items = new HashMap<Item, Integer>();
        NonNullList remaining = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        ItemStack tool_item = ItemStack.EMPTY;
        for (int i2 = 0; i2 < inv.getContainerSize(); ++i2) {
            ItemStack stack2 = inv.getItem(i2);
            if (stack2.isEmpty()) continue;
            if (Auxiliaries.getResourceLocation(stack2.getItem()).toString().equals(tool_name)) {
                tool_item = stack2.copy();
                continue;
            }
            remaining.set(i2, (Object)stack2.copy());
            repair_items.put(stack2.getItem(), stack2.getCount() + repair_items.getOrDefault(stack2.getItem(), 0));
        }
        if (tool_item.isEmpty()) {
            return new Tuple((Object)ItemStack.EMPTY, (Object)remaining);
        }
        if (tool_item.getMaxDamage() <= 0) {
            Auxiliaries.logWarn("Repairing '" + Auxiliaries.getResourceLocation(tool_item.getItem()) + "' can't work, the item is not damageable.");
            return new Tuple((Object)ItemStack.EMPTY, (Object)remaining);
        }
        int dmg = tool_item.getDamageValue();
        if (dmg <= 0 && !this.aspects.getBoolean("over_repair")) {
            return new Tuple((Object)ItemStack.EMPTY, (Object)remaining);
        }
        int min_repair_item_count = repair_items.values().stream().mapToInt(Integer::intValue).min().orElse(0);
        if (min_repair_item_count <= 0) {
            return new Tuple((Object)ItemStack.EMPTY, (Object)remaining);
        }
        int single_repair_dur = this.aspects.getBoolean("relative_repair_damage") ? Math.max(1, -this.getToolDamage() * tool_item.getMaxDamage() / 100) : Math.max(1, -this.getToolDamage());
        int num_repairs = dmg / single_repair_dur;
        if (num_repairs * single_repair_dur < dmg) {
            ++num_repairs;
        }
        num_repairs = Math.min(num_repairs, min_repair_item_count);
        for (Item ki : repair_items.keySet()) {
            repair_items.put(ki, num_repairs);
        }
        tool_item.setDamageValue(Math.max(dmg - single_repair_dur * num_repairs, 0));
        for (i = 0; i < remaining.size(); ++i) {
            stack = inv.getItem(i);
            if (stack.isEmpty() || Auxiliaries.getResourceLocation(stack.getItem()).toString().equals(tool_name)) continue;
            remaining.set(i, (Object)(stack.getItem().hasCraftingRemainingItem() ? new ItemStack((ItemLike)stack.getItem().getCraftingRemainingItem(), stack.getCount()) : stack.copy()));
        }
        for (i = 0; i < remaining.size(); ++i) {
            stack = (ItemStack)remaining.get(i);
            Item item = stack.getItem();
            if (!repair_items.containsKey(item)) continue;
            int n = (Integer)repair_items.get(item);
            if (stack.getCount() >= n) {
                stack.shrink(n);
                repair_items.remove(item);
                continue;
            }
            repair_items.put(item, n - stack.getCount());
            remaining.set(i, (Object)ItemStack.EMPTY);
        }
        if (tool_item.getItem() instanceof IRepairableToolItem) {
            tool_item = ((IRepairableToolItem)tool_item.getItem()).onShapelessRecipeRepaired(tool_item, dmg, tool_item.getDamageValue());
        }
        return new Tuple((Object)tool_item, (Object)remaining);
    }

    public boolean isSpecial() {
        return this.isRepair() || this.aspects.getBoolean("dynamic");
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        if (this.isRepair()) {
            NonNullList remaining = (NonNullList)this.getRepaired(inv).getB();
            for (int i = 0; i < remaining.size(); ++i) {
                ItemStack rem_stack = (ItemStack)remaining.get(i);
                ItemStack inv_stack = inv.getItem(i);
                if (inv_stack.isEmpty() || !rem_stack.isEmpty() && !inv.getItem(i).is(rem_stack.getItem())) continue;
                remaining.set(i, (Object)ItemStack.EMPTY);
                rem_stack.grow(1);
                inv.setItem(i, rem_stack);
            }
            return remaining;
        }
        String tool_name = this.aspects.getString("tool");
        int tool_damage = this.getToolDamage();
        NonNullList remaining = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (Auxiliaries.getResourceLocation(stack.getItem()).toString().equals(tool_name)) {
                if (!stack.isDamageableItem() || stack.getMaxDamage() <= 0) {
                    remaining.set(i, (Object)stack);
                    continue;
                }
                ItemStack rstack = stack.copy();
                rstack.setDamageValue(rstack.getDamageValue() + tool_damage);
                if (rstack.getDamageValue() >= rstack.getMaxDamage()) continue;
                remaining.set(i, (Object)rstack);
                continue;
            }
            if (!stack.getItem().hasCraftingRemainingItem()) continue;
            remaining.set(i, (Object)new ItemStack((ItemLike)stack.getItem().getCraftingRemainingItem(), stack.getCount()));
        }
        return remaining;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess ra) {
        int dmg;
        if (this.isRepair()) {
            return (ItemStack)this.getRepaired(inv).getA();
        }
        ItemStack rstack = super.assemble(inv, ra);
        if (rstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (this.aspects.getInt("initial_durability") > 0) {
            int dmg2 = Math.max(0, rstack.getMaxDamage() - this.aspects.getInt("initial_durability"));
            if (dmg2 > 0) {
                rstack.setDamageValue(dmg2);
            }
        } else if (this.aspects.getInt("initial_damage") > 0 && (dmg = Math.min(this.aspects.getInt("initial_damage"), rstack.getMaxDamage())) > 0) {
            rstack.setDamageValue(dmg);
        }
        return rstack;
    }

    public ItemStack getResultItem(RegistryAccess ra) {
        return this.isSpecial() ? ItemStack.EMPTY : this.resultItem;
    }

    public static interface IRepairableToolItem {
        public ItemStack onShapelessRecipeRepaired(ItemStack var1, int var2, int var3);
    }

    public static class Serializer
    implements RecipeSerializer<ExtendedShapelessRecipe> {
        private static final Codec<CompoundTag> NBT_CODEC = ExtraCodecs.xor((Codec)Codec.STRING, (Codec)CompoundTag.CODEC).flatXmap(either -> (DataResult)either.map(s -> {
            try {
                return DataResult.success((Object)TagParser.parseTag((String)s));
            }
            catch (CommandSyntaxException e) {
                return DataResult.error(() -> ((CommandSyntaxException)e).getMessage());
            }
        }, DataResult::success), nbt -> DataResult.success((Object)Either.left((Object)nbt.getAsString())));
        private static final Codec<ExtendedShapelessRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(ShapelessRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapelessRecipe::category), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(recipe -> recipe.resultItem), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(ShapelessRecipe::getIngredients), (App)ExtraCodecs.strictOptionalField(NBT_CODEC, (String)"aspects", (Object)new CompoundTag()).forGetter(ExtendedShapelessRecipe::getAspects)).apply((Applicative)instance, ExtendedShapelessRecipe::new));

        public Codec<ExtendedShapelessRecipe> codec() {
            return CODEC;
        }

        public ExtendedShapelessRecipe fromNetwork(FriendlyByteBuf pkt) {
            String group = pkt.readUtf();
            CraftingBookCategory cat = (CraftingBookCategory)pkt.readEnum(CraftingBookCategory.class);
            int size = pkt.readVarInt();
            NonNullList nonNullList = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            nonNullList.replaceAll(ignored -> Ingredient.fromNetwork((FriendlyByteBuf)pkt));
            ItemStack stack = pkt.readItem();
            CompoundTag aspects = pkt.readNbt();
            return new ExtendedShapelessRecipe(group, cat, stack, (NonNullList<Ingredient>)nonNullList, aspects);
        }

        public void toNetwork(FriendlyByteBuf pkt, ExtendedShapelessRecipe recipe) {
            pkt.writeUtf(recipe.getGroup());
            pkt.writeEnum((Enum)recipe.category());
            pkt.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ingredient : recipe.getIngredients()) {
                ingredient.toNetwork(pkt);
            }
            pkt.writeItem(recipe.getResultItem(null));
            pkt.writeNbt((Tag)recipe.getAspects());
        }
    }
}

