/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.TooltipDisplay;

public class Guis {

    @OnlyIn(value=Dist.CLIENT)
    public static class TextBox
    extends EditBox {
        public TextBox(int x, int y, int width, int height, Component title, Font font) {
            super(font, x, y, width, height, title);
            this.setBordered(false);
        }

        public TextBox withMaxLength(int len) {
            super.setMaxLength(len);
            return this;
        }

        public TextBox withBordered(boolean b) {
            super.setBordered(b);
            return this;
        }

        public TextBox withValue(String s) {
            super.setValue(s);
            return this;
        }

        public TextBox withEditable(boolean e) {
            super.setEditable(e);
            return this;
        }

        public TextBox withResponder(Consumer<String> r) {
            super.setResponder(r);
            return this;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Image
    extends UiWidget {
        private final Coord2d texture_position_;
        private final ResourceLocation atlas_;

        public Image(ResourceLocation atlas, int width, int height, Coord2d atlas_texture_position) {
            super(0, 0, width, height, (Component)Component.empty());
            this.texture_position_ = atlas_texture_position;
            this.atlas_ = atlas;
        }

        public void onClick(double mouseX, double mouseY) {
        }

        @Override
        protected void renderWidget(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.atlas_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            Coord2d pos = this.texture_position_;
            gg.blit(this.atlas_, this.getX(), this.getY(), pos.x, pos.y, this.width, this.height);
            if (this.isHovered) {
                this.renderToolTip(gg, mouseX, mouseY);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ImageButton
    extends UiWidget {
        private final Coord2d texture_position_;
        private final ResourceLocation atlas_;
        private Consumer<ImageButton> on_click_ = bt -> {};

        public ImageButton(ResourceLocation atlas, int width, int height, Coord2d atlas_texture_position) {
            super(0, 0, width, height, (Component)Component.empty());
            this.texture_position_ = atlas_texture_position;
            this.atlas_ = atlas;
        }

        public ImageButton onclick(Consumer<ImageButton> action) {
            this.on_click_ = action;
            return this;
        }

        public void onClick(double mouseX, double mouseY) {
            this.on_click_.accept(this);
        }

        @Override
        protected void renderWidget(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.atlas_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            Coord2d pos = this.texture_position_;
            gg.blit(this.atlas_, this.getX(), this.getY(), pos.x, pos.y, this.width, this.height);
            if (this.isHovered) {
                this.renderToolTip(gg, mouseX, mouseY);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CheckBox
    extends UiWidget {
        private final Coord2d texture_position_off_;
        private final Coord2d texture_position_on_;
        private final ResourceLocation atlas_;
        private boolean checked_ = false;
        private Consumer<CheckBox> on_click_ = checkbox -> {};

        public CheckBox(ResourceLocation atlas, int width, int height, Coord2d atlas_texture_position_off, Coord2d atlas_texture_position_on) {
            super(0, 0, width, height, EMPTY_TEXT);
            this.texture_position_off_ = atlas_texture_position_off;
            this.texture_position_on_ = atlas_texture_position_on;
            this.atlas_ = atlas;
        }

        public boolean checked() {
            return this.checked_;
        }

        public CheckBox checked(boolean on) {
            this.checked_ = on;
            return this;
        }

        public CheckBox onclick(Consumer<CheckBox> action) {
            this.on_click_ = action;
            return this;
        }

        public void onClick(double mouseX, double mouseY) {
            this.checked_ = !this.checked_;
            this.on_click_.accept(this);
        }

        @Override
        protected void renderWidget(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.atlas_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            Coord2d pos = this.checked_ ? this.texture_position_on_ : this.texture_position_off_;
            gg.blit(this.atlas_, this.getX(), this.getY(), pos.x, pos.y, this.width, this.height);
            if (this.isHovered) {
                this.renderToolTip(gg, mouseX, mouseY);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BackgroundImage
    extends UiWidget {
        private final ResourceLocation atlas_;
        private final Coord2d atlas_position_;
        public boolean visible;

        public BackgroundImage(ResourceLocation atlas, int width, int height, Coord2d atlas_position) {
            super(0, 0, width, height, EMPTY_TEXT);
            this.atlas_ = atlas;
            this.atlas_position_ = atlas_position;
            this.width = width;
            this.height = height;
            this.visible = true;
        }

        public void draw(GuiGraphics gg, Screen parent) {
            if (!this.visible) {
                return;
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.atlas_);
            gg.blit(this.atlas_, this.getX(), this.getY(), this.atlas_position_.x, this.atlas_position_.y, this.width, this.height);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class HorizontalProgressBar
    extends UiWidget {
        private final Coord2d texture_position_base_;
        private final Coord2d texture_position_filled_;
        private final ResourceLocation atlas_;
        private double progress_max_ = 100.0;
        private double progress_ = 0.0;

        public HorizontalProgressBar(ResourceLocation atlas, int width, int height, Coord2d base_texture_xy, Coord2d filled_texture_xy) {
            super(0, 0, width, height, EMPTY_TEXT);
            this.atlas_ = atlas;
            this.texture_position_base_ = base_texture_xy;
            this.texture_position_filled_ = filled_texture_xy;
        }

        public HorizontalProgressBar setProgress(double progress) {
            this.progress_ = Mth.clamp((double)progress, (double)0.0, (double)this.progress_max_);
            return this;
        }

        public double getProgress() {
            return this.progress_;
        }

        public HorizontalProgressBar setMaxProgress(double progress) {
            this.progress_max_ = Math.max(progress, 0.0);
            return this;
        }

        public double getMaxProgress() {
            return this.progress_max_;
        }

        @Override
        public HorizontalProgressBar show() {
            this.visible = true;
            return this;
        }

        @Override
        public HorizontalProgressBar hide() {
            this.visible = false;
            return this;
        }

        public void playDownSound(SoundManager handler) {
        }

        @Override
        protected void renderWidget(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.atlas_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            gg.blit(this.atlas_, this.getX(), this.getY(), this.texture_position_base_.x, this.texture_position_base_.y, this.width, this.height);
            if (this.progress_max_ > 0.0 && this.progress_ > 0.0) {
                int w = Mth.clamp((int)((int)Math.round(this.progress_ * (double)this.width / this.progress_max_)), (int)0, (int)this.width);
                gg.blit(this.atlas_, this.getX(), this.getY(), this.texture_position_filled_.x, this.texture_position_filled_.y, w, this.height);
            }
            if (this.isHovered) {
                this.renderToolTip(gg, mouseX, mouseY);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class UiWidget
    extends AbstractWidget {
        protected static final Component EMPTY_TEXT = Component.literal((String)"");
        protected static final Function<UiWidget, Component> NO_TOOLTIP = uiw -> EMPTY_TEXT;
        private final Minecraft mc_;
        private Function<UiWidget, Component> tooltip_ = NO_TOOLTIP;
        private Screen parent_;

        public UiWidget(int x, int y, int width, int height, Component title) {
            super(x, y, width, height, title);
            this.mc_ = Minecraft.getInstance();
        }

        public UiWidget init(Screen parent) {
            this.parent_ = parent;
            this.setX(this.getX() + (parent instanceof AbstractContainerScreen ? ((AbstractContainerScreen)parent).getGuiLeft() : 0));
            this.setY(this.getY() + (parent instanceof AbstractContainerScreen ? ((AbstractContainerScreen)parent).getGuiTop() : 0));
            return this;
        }

        public UiWidget init(Screen parent, Coord2d position) {
            this.parent_ = parent;
            this.setX(position.x + (parent instanceof AbstractContainerScreen ? ((AbstractContainerScreen)parent).getGuiLeft() : 0));
            this.setY(position.y + (parent instanceof AbstractContainerScreen ? ((AbstractContainerScreen)parent).getGuiTop() : 0));
            return this;
        }

        public final UiWidget tooltip(Function<UiWidget, Component> tip) {
            this.tooltip_ = tip;
            return this;
        }

        public final UiWidget tooltip(Component tip) {
            this.tooltip_ = o -> tip;
            return this;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public Coord2d getMousePosition() {
            Window win = this.mc_.getWindow();
            return Coord2d.of(Mth.clamp((int)((int)(this.mc_.mouseHandler.xpos() * (double)win.getGuiScaledWidth() / (double)win.getScreenWidth()) - this.getX()), (int)-1, (int)(this.width + 1)), Mth.clamp((int)((int)(this.mc_.mouseHandler.ypos() * (double)win.getGuiScaledHeight() / (double)win.getScreenHeight()) - this.getY()), (int)-1, (int)(this.height + 1)));
        }

        protected final Coord2d screenCoordinates(Coord2d xy, boolean reverse) {
            return reverse ? Coord2d.of(xy.x + this.getX(), xy.y + this.getY()) : Coord2d.of(xy.x - this.getX(), xy.y - this.getY());
        }

        public UiWidget show() {
            this.visible = true;
            return this;
        }

        public UiWidget hide() {
            this.visible = false;
            return this;
        }

        protected void updateWidgetNarration(NarrationElementOutput neo) {
        }

        protected void renderWidget(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            if (this.isHovered) {
                this.renderToolTip(gg, mouseX, mouseY);
            }
        }

        public void renderToolTip(GuiGraphics gg, int mouseX, int mouseY) {
            if (!this.visible || !this.active || this.tooltip_ == NO_TOOLTIP) {
                return;
            }
            Component tip = this.tooltip_.apply(this);
            if (tip.getString().trim().isEmpty()) {
                return;
            }
            gg.renderTooltip(this.mc_.font, List.of(tip.getVisualOrderText()), mouseX, mouseY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Coord2d {
        public static final Coord2d ORIGIN = new Coord2d(0, 0);
        public final int x;
        public final int y;

        public Coord2d(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public static Coord2d of(int x, int y) {
            return new Coord2d(x, y);
        }

        public String toString() {
            return "[" + this.x + "," + this.y + "]";
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class ContainerGui<T extends AbstractContainerMenu>
    extends AbstractContainerScreen<T> {
        protected final ResourceLocation background_image_;
        protected final Player player_;
        protected final BackgroundImage gui_background_;
        protected final TooltipDisplay tooltip_ = new TooltipDisplay();

        public ContainerGui(T menu, Inventory player_inv, Component title, String background_image, int width, int height) {
            super(menu, player_inv, title);
            this.background_image_ = new ResourceLocation(Auxiliaries.modid(), background_image);
            this.player_ = player_inv.player;
            this.imageWidth = width;
            this.imageHeight = height;
            this.gui_background_ = new BackgroundImage(this.background_image_, width, height, Coord2d.ORIGIN);
        }

        public ContainerGui(T menu, Inventory player_inv, Component title, String background_image) {
            super(menu, player_inv, title);
            this.background_image_ = new ResourceLocation(Auxiliaries.modid(), background_image);
            this.player_ = player_inv.player;
            this.gui_background_ = new BackgroundImage(this.background_image_, this.imageWidth, this.imageHeight, Coord2d.ORIGIN);
        }

        public void init() {
            super.init();
            this.gui_background_.init((Screen)this, Coord2d.ORIGIN).show();
        }

        public void render(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            this.renderBackground(gg, mouseX, mouseY, partialTicks);
            super.render(gg, mouseX, mouseY, partialTicks);
            if (!this.tooltip_.render(gg, this, mouseX, mouseY)) {
                this.renderTooltip(gg, mouseX, mouseY);
            }
        }

        protected void renderLabels(GuiGraphics gg, int x, int y) {
        }

        protected final void renderBg(GuiGraphics gg, float partialTicks, int mouseX, int mouseY) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            this.gui_background_.draw(gg, (Screen)this);
            this.renderBgWidgets(gg, partialTicks, mouseX, mouseY);
            RenderSystem.disableBlend();
        }

        public final ResourceLocation getBackgroundImage() {
            return this.background_image_;
        }

        protected void renderBgWidgets(GuiGraphics gg, float partialTicks, int mouseX, int mouseY) {
        }

        protected void renderItemTemplate(GuiGraphics gg, ItemStack stack, int x, int y) {
            gg.renderItem(stack, x, y);
        }
    }
}

