/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import wile.redstonepen.libmc.Auxiliaries;

public class Networking {
    public static void init(RegisterPayloadHandlerEvent event) {
        String modid = "redstonepen";
        IPayloadRegistrar registrar = event.registrar("redstonepen");
        PacketTileNotifyClientToServer.PacketData.PACKET_ID = new ResourceLocation("redstonepen", "tnc2s");
        registrar.play(PacketTileNotifyClientToServer.PacketData.PACKET_ID, PacketTileNotifyClientToServer.PacketData::new, hnd -> hnd.server(PacketTileNotifyClientToServer::onReceive));
        PacketTileNotifyServerToClient.PacketData.PACKET_ID = new ResourceLocation("redstonepen", "tns2c");
        registrar.play(PacketTileNotifyServerToClient.PacketData.PACKET_ID, PacketTileNotifyServerToClient.PacketData::new, hnd -> hnd.client(PacketTileNotifyServerToClient::onReceive));
        PacketContainerSyncClientToServer.PacketData.PACKET_ID = new ResourceLocation("redstonepen", "csc2s");
        registrar.play(PacketContainerSyncClientToServer.PacketData.PACKET_ID, PacketContainerSyncClientToServer.PacketData::new, hnd -> hnd.server(PacketContainerSyncClientToServer::onReceive));
        PacketContainerSyncServerToClient.PacketData.PACKET_ID = new ResourceLocation("redstonepen", "css2c");
        registrar.play(PacketContainerSyncServerToClient.PacketData.PACKET_ID, PacketContainerSyncServerToClient.PacketData::new, hnd -> hnd.client(PacketContainerSyncServerToClient::onReceive));
        PacketNbtNotifyClientToServer.PacketData.PACKET_ID = new ResourceLocation("redstonepen", "nnc2s");
        registrar.play(PacketNbtNotifyClientToServer.PacketData.PACKET_ID, PacketNbtNotifyClientToServer.PacketData::new, hnd -> hnd.server(PacketNbtNotifyClientToServer::onReceive));
        PacketNbtNotifyServerToClient.PacketData.PACKET_ID = new ResourceLocation("redstonepen", "nns2c");
        registrar.play(PacketNbtNotifyServerToClient.PacketData.PACKET_ID, PacketNbtNotifyServerToClient.PacketData::new, hnd -> hnd.client(PacketNbtNotifyServerToClient::onReceive));
        OverlayTextMessage.PacketData.PACKET_ID = new ResourceLocation("redstonepen", "ols2c");
        registrar.play(OverlayTextMessage.PacketData.PACKET_ID, OverlayTextMessage.PacketData::new, hnd -> hnd.client(OverlayTextMessage::onReceive));
    }

    public static class PacketTileNotifyClientToServer {
        private static void onReceive(PacketData data, PlayPayloadContext context) {
            BlockPos pos = data.pos();
            CompoundTag nbt = data.nbt();
            Player player = context.player().orElse(null);
            Level world = context.level().orElse(null);
            if (world == null || player == null) {
                return;
            }
            context.workHandler().submitAsync(() -> {
                BlockEntity te = world.getBlockEntity(pos);
                if (!(te instanceof IPacketTileNotifyReceiver)) {
                    return;
                }
                IPacketTileNotifyReceiver tnr = (IPacketTileNotifyReceiver)te;
                tnr.onClientPacketReceived(player, nbt);
            });
        }

        public static void sendToServer(BlockPos pos, CompoundTag nbt) {
            if (pos == null || nbt == null) {
                return;
            }
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketData(pos, nbt)});
        }

        public static void sendToServer(BlockEntity te, CompoundTag nbt) {
            if (te != null) {
                PacketTileNotifyClientToServer.sendToServer(te.getBlockPos(), nbt);
            }
        }

        private record PacketData(BlockPos pos, CompoundTag nbt) implements CustomPacketPayload
        {
            private static ResourceLocation PACKET_ID;

            PacketData(FriendlyByteBuf buf) {
                this(buf.readBlockPos(), buf.readNbt());
            }

            public ResourceLocation id() {
                return PACKET_ID;
            }

            public void write(FriendlyByteBuf buffer) {
                buffer.writeBlockPos(this.pos());
                buffer.writeNbt((Tag)this.nbt());
            }
        }
    }

    public static class PacketTileNotifyServerToClient {
        private static void onReceive(PacketData data, PlayPayloadContext context) {
            BlockPos pos = data.pos();
            CompoundTag nbt = data.nbt();
            Level world = context.level().orElse(null);
            if (world == null) {
                return;
            }
            context.workHandler().submitAsync(() -> {
                BlockEntity te = world.getBlockEntity(pos);
                if (!(te instanceof IPacketTileNotifyReceiver)) {
                    return;
                }
                IPacketTileNotifyReceiver tnr = (IPacketTileNotifyReceiver)te;
                tnr.onServerPacketReceived(nbt);
            });
        }

        public static void sendToPlayer(ServerPlayer player, BlockEntity te, CompoundTag nbt) {
            if (te == null || nbt == null || te.getLevel().isClientSide()) {
                return;
            }
            PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new PacketData(te.getBlockPos(), nbt)});
        }

        public static void sendToPlayers(BlockEntity te, CompoundTag nbt) {
            Object object;
            if (te == null || !((object = te.getLevel()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel sl = (ServerLevel)object;
            for (ServerPlayer player : sl.players()) {
                PacketTileNotifyServerToClient.sendToPlayer(player, te, nbt);
            }
        }

        private record PacketData(BlockPos pos, CompoundTag nbt) implements CustomPacketPayload
        {
            private static ResourceLocation PACKET_ID;

            PacketData(FriendlyByteBuf buf) {
                this(buf.readBlockPos(), buf.readNbt());
            }

            public ResourceLocation id() {
                return PACKET_ID;
            }

            public void write(FriendlyByteBuf buffer) {
                buffer.writeBlockPos(this.pos());
                buffer.writeNbt((Tag)this.nbt());
            }
        }
    }

    public static class PacketContainerSyncClientToServer {
        private static void onReceive(PacketData data, PlayPayloadContext context) {
            int cid = data.container_id();
            CompoundTag nbt = data.nbt();
            Player player = context.player().orElse(null);
            context.workHandler().submitAsync(() -> {
                AbstractContainerMenu patt8090$temp;
                if (player == null || !((patt8090$temp = player.containerMenu) instanceof INetworkSynchronisableContainer)) {
                    return;
                }
                INetworkSynchronisableContainer nsc = (INetworkSynchronisableContainer)patt8090$temp;
                if (player.containerMenu.containerId != cid) {
                    return;
                }
                nsc.onClientPacketReceived(cid, player, nbt);
            });
        }

        public static void sendToServer(int container_id, CompoundTag nbt) {
            if (nbt == null) {
                return;
            }
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketData(container_id, nbt)});
        }

        public static void sendToServer(AbstractContainerMenu container, CompoundTag nbt) {
            PacketContainerSyncClientToServer.sendToServer(container.containerId, nbt);
        }

        private record PacketData(int container_id, CompoundTag nbt) implements CustomPacketPayload
        {
            private static ResourceLocation PACKET_ID;

            PacketData(FriendlyByteBuf buf) {
                this(buf.readInt(), buf.readNbt());
            }

            public ResourceLocation id() {
                return PACKET_ID;
            }

            public void write(FriendlyByteBuf buffer) {
                buffer.writeInt(this.container_id());
                buffer.writeNbt((Tag)this.nbt());
            }
        }
    }

    public static class PacketContainerSyncServerToClient {
        private static void onReceive(PacketData data, PlayPayloadContext context) {
            int cid = data.container_id();
            CompoundTag nbt = data.nbt();
            Player player = context.player().orElse(null);
            context.workHandler().submitAsync(() -> {
                AbstractContainerMenu patt9456$temp;
                if (player == null || !((patt9456$temp = player.containerMenu) instanceof INetworkSynchronisableContainer)) {
                    return;
                }
                INetworkSynchronisableContainer nsc = (INetworkSynchronisableContainer)patt9456$temp;
                if (player.containerMenu.containerId != cid) {
                    return;
                }
                nsc.onServerPacketReceived(cid, nbt);
            });
        }

        public static void sendToPlayer(ServerPlayer player, int container_id, CompoundTag nbt) {
            if (nbt == null || player == null) {
                return;
            }
            PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new PacketData(container_id, nbt)});
        }

        public static void sendToPlayer(ServerPlayer player, AbstractContainerMenu container, CompoundTag nbt) {
            if (container != null) {
                PacketContainerSyncServerToClient.sendToPlayer(player, container.containerId, nbt);
            }
        }

        public static <C extends AbstractContainerMenu> void sendToListeners(Level world, C container, CompoundTag nbt) {
            if (!(world instanceof ServerLevel)) {
                return;
            }
            ServerLevel sw = (ServerLevel)world;
            for (ServerPlayer player : sw.players()) {
                if (player.containerMenu.containerId != container.containerId) continue;
                PacketContainerSyncServerToClient.sendToPlayer(player, container.containerId, nbt);
            }
        }

        private record PacketData(int container_id, CompoundTag nbt) implements CustomPacketPayload
        {
            private static ResourceLocation PACKET_ID;

            PacketData(FriendlyByteBuf buf) {
                this(buf.readInt(), buf.readNbt());
            }

            public ResourceLocation id() {
                return PACKET_ID;
            }

            public void write(FriendlyByteBuf buffer) {
                buffer.writeInt(this.container_id());
                buffer.writeNbt((Tag)this.nbt());
            }
        }
    }

    public static class PacketNbtNotifyClientToServer {
        public static final Map<String, BiConsumer<Player, CompoundTag>> handlers = new HashMap<String, BiConsumer<Player, CompoundTag>>();

        private static void onReceive(PacketData data, PlayPayloadContext context) {
            CompoundTag nbt = data.nbt();
            Player player = context.player().orElse(null);
            if (player == null || nbt == null) {
                return;
            }
            String hnd = nbt.getString("hnd");
            if (hnd.isEmpty() || !handlers.containsKey(hnd)) {
                return;
            }
            context.workHandler().submitAsync(() -> handlers.get(hnd).accept(player, nbt));
        }

        public static void sendToServer(CompoundTag nbt) {
            if (nbt == null) {
                return;
            }
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketData(nbt)});
        }

        private record PacketData(CompoundTag nbt) implements CustomPacketPayload
        {
            private static ResourceLocation PACKET_ID;

            PacketData(FriendlyByteBuf buf) {
                this(buf.readNbt());
            }

            public ResourceLocation id() {
                return PACKET_ID;
            }

            public void write(FriendlyByteBuf buffer) {
                buffer.writeNbt((Tag)this.nbt());
            }
        }
    }

    public static class PacketNbtNotifyServerToClient {
        public static final Map<String, Consumer<CompoundTag>> handlers = new HashMap<String, Consumer<CompoundTag>>();

        private static void onReceive(PacketData data, PlayPayloadContext context) {
            CompoundTag nbt = data.nbt();
            if (nbt == null) {
                return;
            }
            String hnd = nbt.getString("hnd");
            if (hnd.isEmpty() || !handlers.containsKey(hnd)) {
                return;
            }
            context.workHandler().submitAsync(() -> handlers.get(hnd).accept(nbt));
        }

        public static void sendToPlayer(Player player, CompoundTag nbt) {
            if (nbt == null || !(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            PacketDistributor.PLAYER.with((Object)sp).send(new CustomPacketPayload[]{new PacketData(nbt)});
        }

        public static void sendToPlayers(ServerLevel world, CompoundTag nbt) {
            if (world != null) {
                for (ServerPlayer player : world.players()) {
                    PacketNbtNotifyServerToClient.sendToPlayer((Player)player, nbt);
                }
            }
        }

        private record PacketData(CompoundTag nbt) implements CustomPacketPayload
        {
            private static ResourceLocation PACKET_ID;

            PacketData(FriendlyByteBuf buf) {
                this(buf.readNbt());
            }

            public ResourceLocation id() {
                return PACKET_ID;
            }

            public void write(FriendlyByteBuf buffer) {
                buffer.writeNbt((Tag)this.nbt());
            }
        }
    }

    public static class OverlayTextMessage {
        protected static BiConsumer<Component, Integer> handler_ = null;
        public static final int DISPLAY_TIME_MS = 3000;

        private static void onReceive(PacketData data, PlayPayloadContext context) {
            if (handler_ == null) {
                return;
            }
            Component message = data.message();
            int delay = data.delay();
            if (delay <= 0) {
                return;
            }
            context.workHandler().submitAsync(() -> handler_.accept(message, delay));
        }

        public static void setHandler(BiConsumer<Component, Integer> handler) {
            if (handler_ == null) {
                handler_ = handler;
            }
        }

        public static void sendToPlayer(ServerPlayer player, Component message) {
            OverlayTextMessage.sendToPlayer(player, message, 3000);
        }

        public static void sendToPlayer(ServerPlayer player, Component message, int delay) {
            if (Auxiliaries.isEmpty(message)) {
                return;
            }
            PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new PacketData(message, delay)});
        }

        public record PacketData(Component message, int delay) implements CustomPacketPayload
        {
            private static ResourceLocation PACKET_ID;

            PacketData(FriendlyByteBuf buf) {
                this(PacketData.get_component(buf), buf.readInt());
            }

            private static Component get_component(FriendlyByteBuf buf) {
                try {
                    return buf.readComponent();
                }
                catch (Throwable e) {
                    return Component.translatable((String)"[incorrect translation]");
                }
            }

            public ResourceLocation id() {
                return PACKET_ID;
            }

            public void write(FriendlyByteBuf buffer) {
                buffer.writeComponent(this.message());
                buffer.writeInt(this.delay());
            }
        }
    }

    public static interface INetworkSynchronisableContainer {
        public void onServerPacketReceived(int var1, CompoundTag var2);

        public void onClientPacketReceived(int var1, Player var2, CompoundTag var3);
    }

    public static interface IPacketTileNotifyReceiver {
        default public void onServerPacketReceived(CompoundTag nbt) {
        }

        default public void onClientPacketReceived(Player player, CompoundTag nbt) {
        }
    }
}

